/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.monobank.content.monobank;

import io.github.mortuusars.monobank.Registry;
import io.github.mortuusars.monobank.Thief;
import io.github.mortuusars.monobank.config.Configuration;
import io.github.mortuusars.monobank.content.monobank.MonobankBlockEntity;
import io.github.mortuusars.monobank.util.TextUtil;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MonobankBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;

    public MonobankBlock() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76365_).m_60913_(8.0f, 1200.0f).m_60955_().m_60918_(SoundType.f_56725_));
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)mirror.m_54848_((Direction)state.m_61143_((Property)FACING)));
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    public float m_5880_(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        MonobankBlockEntity monobankEntity;
        BlockEntity blockEntity;
        if (!((Boolean)Configuration.CAN_RELOCATE_OTHER_PLAYERS_BANK.get()).booleanValue() && (blockEntity = level.m_7702_(pos)) instanceof MonobankBlockEntity && (monobankEntity = (MonobankBlockEntity)blockEntity).getOwner().isPlayerOwned() && !monobankEntity.getOwner().isOwnedBy(player)) {
            return 0.0f;
        }
        return super.m_5880_(state, player, level, pos);
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return ((BlockEntityType)Registry.BlockEntityTypes.MONOBANK.get()).m_155264_(pos, state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        MonobankBlockEntity monobankEntity;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof MonobankBlockEntity && !(monobankEntity = (MonobankBlockEntity)blockEntity).getLock().isLocked()) {
            float fullness = monobankEntity.getFullness();
            return Mth.m_14045_((int)((int)Math.floor(fullness * 14.0f)), (int)0, (int)14) + (fullness > 0.0f ? 1 : 0);
        }
        return 0;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        MonobankBlockEntity.appendHoverText(stack, level, tooltip, flag);
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity;
        if (!level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof MonobankBlockEntity) {
            MonobankBlockEntity monobankEntity = (MonobankBlockEntity)blockEntity;
            monobankEntity.unpackLootTable(player, true);
            monobankEntity.checkAndPunishForCrime(player, Thief.Offence.HEAVY);
        }
        super.m_5707_(level, pos, state, player);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @javax.annotation.Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof MonobankBlockEntity)) {
            return;
        }
        MonobankBlockEntity monobankBlockEntity = (MonobankBlockEntity)blockEntity;
        if (stack.m_41788_()) {
            monobankBlockEntity.setCustomName(stack.m_41786_());
        }
        monobankBlockEntity.onSetPlacedBy(placer, stack);
    }

    public boolean m_8133_(BlockState pState, Level pLevel, BlockPos pPos, int pId, int pParam) {
        super.m_8133_(pState, pLevel, pPos, pId, pParam);
        BlockEntity blockentity = pLevel.m_7702_(pPos);
        return blockentity != null && blockentity.m_7531_(pId, pParam);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> entityType) {
        return entityType == Registry.BlockEntityTypes.MONOBANK.get() && level.f_46443_ ? MonobankBlockEntity::clientTick : MonobankBlockEntity::serverTick;
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof MonobankBlockEntity)) {
            return InteractionResult.FAIL;
        }
        MonobankBlockEntity monobankBlockEntity = (MonobankBlockEntity)blockEntity;
        return player.m_36341_() ? this.tryLockOrUnlock(blockState, player, level, pos, monobankBlockEntity) : this.tryOpen(blockState, player, level, pos, monobankBlockEntity);
    }

    private InteractionResult tryOpen(BlockState blockState, Player player, Level level, BlockPos pos, MonobankBlockEntity monobankEntity) {
        if (monobankEntity.getLock().isLocked()) {
            if (level.f_46443_) {
                String hotkey = Minecraft.m_91087_().f_91066_.f_92090_.getKey().m_84875_().m_130668_(999) + "+" + Minecraft.m_91087_().f_91066_.f_92095_.getKey().m_84875_().m_130668_(999);
                player.m_5661_((Component)TextUtil.translate("message.monobank.locking.monobank_is_locked", hotkey), true);
                return InteractionResult.SUCCESS;
            }
            monobankEntity.playSoundAtDoor((SoundEvent)Registry.Sounds.MONOBANK_CLICK.get());
        } else if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            monobankEntity.open(serverPlayer);
        }
        return InteractionResult.CONSUME;
    }

    private InteractionResult tryLockOrUnlock(BlockState blockState, Player player, Level level, BlockPos pos, MonobankBlockEntity monobankEntity) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        boolean isLocked = monobankEntity.getLock().isLocked();
        if (((Boolean)Configuration.OWNER_CAN_UNLOCK_WITHOUT_COMBINATION.get()).booleanValue() && monobankEntity.getOwner().isOwnedBy(player)) {
            boolean shouldBeLocked;
            boolean bl = shouldBeLocked = !isLocked;
            if (shouldBeLocked) {
                monobankEntity.getLock().setLocked(true);
                return InteractionResult.CONSUME;
            }
            if (monobankEntity.isUnlocking()) {
                player.m_5661_((Component)TextUtil.translate("message.monobank.unlocking", new Object[0]), true);
            } else {
                monobankEntity.startUnlocking();
            }
            return InteractionResult.CONSUME;
        }
        if (isLocked) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                monobankEntity.openUnlockingGui(serverPlayer);
            }
            MonobankBlockEntity.playSoundAtDoor(level, pos, blockState, (SoundEvent)Registry.Sounds.MONOBANK_CLICK.get());
        } else {
            monobankEntity.getLock().setLocked(true);
            MonobankBlockEntity.playSoundAtDoor(level, pos, blockState, (SoundEvent)Registry.Sounds.MONOBANK_CLICK.get());
        }
        return InteractionResult.CONSUME;
    }
}

