/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.monobank.core.inventory;

import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class UnlockingSlot
extends SlotItemHandler {
    private ItemStack keyway;
    private Component keywayTooltip;

    public UnlockingSlot(IItemHandler itemHandler, int index, int x, int y, ItemStack keyway) {
        super(itemHandler, index, x, y);
        this.keyway = keyway;
        this.keywayTooltip = this.createKeywayTooltip(keyway);
    }

    private Component createKeywayTooltip(ItemStack keyway) {
        String title = keyway.m_41786_().getString();
        if (title.length() == 0) {
            return Component.m_237113_((String)"");
        }
        String[] split = title.split(" ");
        MutableComponent newTitle = Component.m_237113_((String)"");
        for (int wordIndex = 0; wordIndex < split.length; ++wordIndex) {
            String word = split[wordIndex];
            Random random = new Random(word.hashCode());
            if (word.length() == 0) continue;
            for (int charIndex = 0; charIndex < word.length(); ++charIndex) {
                MutableComponent character = Component.m_237113_((String)("" + word.charAt(charIndex)));
                if (random.nextDouble() > 0.5) {
                    character = character.m_130940_(ChatFormatting.OBFUSCATED).m_130940_(ChatFormatting.GRAY);
                }
                newTitle.m_7220_((Component)character);
            }
            if (wordIndex == split.length - 1) continue;
            newTitle.m_130946_(" ");
        }
        return newTitle;
    }

    public ItemStack getKeyway() {
        return this.keyway;
    }

    public Component getKeywayTooltip() {
        return this.keywayTooltip;
    }
}

