/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.monobank.data.provider;

import com.google.gson.JsonElement;
import io.github.mortuusars.monobank.Monobank;
import io.github.mortuusars.monobank.Registry;
import io.github.mortuusars.monobank.util.TextUtil;
import java.io.IOException;
import java.nio.file.Path;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.StructureTags;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.CopyNameFunction;
import net.minecraft.world.level.storage.loot.functions.CopyNbtFunction;
import net.minecraft.world.level.storage.loot.functions.ExplorationMapFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SetNameFunction;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LootTables
extends LootTableProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private final DataGenerator generator;

    public LootTables(DataGenerator generator) {
        super(generator);
        this.generator = generator;
    }

    public void m_213708_(CachedOutput cache) {
        this.writeTable(cache, Monobank.resource("blocks/monobank"), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)Registry.Items.MONOBANK.get())).m_79078_((LootItemFunction.Builder)CopyNameFunction.m_80187_((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)).m_79078_((LootItemFunction.Builder)CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_).m_80279_("Inventory", "BlockEntityTag.Inventory").m_80279_("Lock", "BlockEntityTag.Lock").m_80279_("Owner", "BlockEntityTag.Owner").m_80279_("LootTable", "BlockEntityTag.LootTable").m_80279_("LootTableSeed", "BlockEntityTag.LootTableSeed"))).m_79080_(ExplosionCondition.m_81661_())).m_79167_());
        LootPool.Builder defaultCombinationPool = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42109_)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42749_)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42026_)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42416_)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41966_)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41967_)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42522_)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42517_)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42446_));
        this.writeTable(cache, Monobank.resource("combination/default"), LootTable.m_79147_().m_79161_(defaultCombinationPool).m_79161_(defaultCombinationPool).m_79161_(defaultCombinationPool).m_79167_());
        LootPool.Builder villageCombinationPool = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42109_)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42749_)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42026_)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42416_)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42590_)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41966_)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41967_)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42522_)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42517_)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42446_));
        this.writeTable(cache, Monobank.resource("combination/village/plains"), LootTable.m_79147_().m_79161_(villageCombinationPool).m_79161_(villageCombinationPool).m_79161_(villageCombinationPool).m_79167_());
        this.writeTable(cache, Monobank.resource("combination/village/taiga"), LootTable.m_79147_().m_79161_(villageCombinationPool).m_79161_(villageCombinationPool).m_79161_(villageCombinationPool).m_79167_());
        this.writeTable(cache, Monobank.resource("combination/village/desert"), LootTable.m_79147_().m_79161_(villageCombinationPool).m_79161_(villageCombinationPool).m_79161_(villageCombinationPool).m_79167_());
        this.writeTable(cache, Monobank.resource("combination/village/snowy"), LootTable.m_79147_().m_79161_(villageCombinationPool).m_79161_(villageCombinationPool).m_79161_(villageCombinationPool).m_79167_());
        this.writeTable(cache, Monobank.resource("combination/village/savanna"), LootTable.m_79147_().m_79161_(villageCombinationPool).m_79161_(villageCombinationPool).m_79161_(villageCombinationPool).m_79167_());
        LootTable monobankVillageLoot = LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42616_).m_79707_(4).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)17.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42110_).m_79707_(4).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42587_).m_79707_(4).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)15.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42417_).m_79707_(4).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)9.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41912_).m_79707_(4).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42676_).m_79078_((LootItemFunction.Builder)ExplorationMapFunction.m_80554_().m_210658_(StructureTags.f_215892_).m_80573_(MapDecoration.Type.RED_X).m_80569_((byte)1).m_80575_(false)).m_79078_((LootItemFunction.Builder)SetNameFunction.m_165457_((Component)TextUtil.translate("filled_map.ruined_portal", new Object[0]))))).m_79167_();
        this.writeTable(cache, Monobank.resource("monobank/village/plains"), monobankVillageLoot);
        this.writeTable(cache, Monobank.resource("monobank/village/taiga"), monobankVillageLoot);
        this.writeTable(cache, Monobank.resource("monobank/village/desert"), monobankVillageLoot);
        this.writeTable(cache, Monobank.resource("monobank/village/snowy"), monobankVillageLoot);
        this.writeTable(cache, Monobank.resource("monobank/village/savanna"), monobankVillageLoot);
    }

    private void writeTable(CachedOutput cache, ResourceLocation location, LootTable lootTable) {
        Path outputFolder = this.generator.m_123916_();
        Path path = outputFolder.resolve("data/" + location.m_135827_() + "/loot_tables/" + location.m_135815_() + ".json");
        try {
            DataProvider.m_236072_((CachedOutput)cache, (JsonElement)net.minecraft.world.level.storage.loot.LootTables.m_79200_((LootTable)lootTable), (Path)path);
        }
        catch (IOException e) {
            LOGGER.error("Couldn't write loot lootTable {}", (Object)path, (Object)e);
        }
    }
}

