/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.monobank.world;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import io.github.mortuusars.monobank.config.Configuration;
import java.util.ArrayList;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import org.slf4j.Logger;

public class VillageStructures {
    private static final ResourceKey<StructureProcessorList> EMPTY_PROCESSOR_LIST_KEY = ResourceKey.m_135785_((ResourceKey)Registry.f_122883_, (ResourceLocation)new ResourceLocation("minecraft", "empty"));
    private static final ResourceKey<StructureProcessorList> MOSSIFY_10_PROCESSOR_LIST_KEY = ResourceKey.m_135785_((ResourceKey)Registry.f_122883_, (ResourceLocation)new ResourceLocation("minecraft", "mossify_10_percent"));
    private static final ResourceKey<StructureProcessorList> STREET_PLAINS_PROCESSOR_LIST_KEY = ResourceKey.m_135785_((ResourceKey)Registry.f_122883_, (ResourceLocation)new ResourceLocation("minecraft", "street_plains"));

    public static void addVillageStructures(ServerAboutToStartEvent event) {
        if (!((Boolean)Configuration.GENERATE_VILLAGE_STRUCTURES.get()).booleanValue()) {
            return;
        }
        Registry templatePools = (Registry)event.getServer().m_206579_().m_6632_(Registry.f_122884_).get();
        Registry processorListsRegistry = (Registry)event.getServer().m_206579_().m_6632_(Registry.f_122883_).get();
        Holder mossify10ProcessorList = processorListsRegistry.m_206081_(MOSSIFY_10_PROCESSOR_LIST_KEY);
        Holder streetPlainsProcessorList = processorListsRegistry.m_206081_(STREET_PLAINS_PROCESSOR_LIST_KEY);
        Integer vaultWeight = (Integer)Configuration.VAULT_WEIGHT.get();
        VillageStructures.addStructureToPoolLegacy((Registry<StructureTemplatePool>)templatePools, (Holder<StructureProcessorList>)streetPlainsProcessorList, new ResourceLocation("minecraft:village/plains/streets"), "monobank:village/streets/plains_straight_fix_01", StructureTemplatePool.Projection.TERRAIN_MATCHING, vaultWeight);
        VillageStructures.addStructureToPoolSingle((Registry<StructureTemplatePool>)templatePools, (Holder<StructureProcessorList>)mossify10ProcessorList, new ResourceLocation("minecraft:village/plains/houses"), "monobank:village/houses/plains_vault", StructureTemplatePool.Projection.RIGID, vaultWeight);
        VillageStructures.addStructureToPoolLegacy((Registry<StructureTemplatePool>)templatePools, (Holder<StructureProcessorList>)streetPlainsProcessorList, new ResourceLocation("minecraft:village/taiga/streets"), "monobank:village/streets/taiga_straight_fix_01", StructureTemplatePool.Projection.TERRAIN_MATCHING, vaultWeight);
        VillageStructures.addStructureToPoolSingle((Registry<StructureTemplatePool>)templatePools, (Holder<StructureProcessorList>)mossify10ProcessorList, new ResourceLocation("minecraft:village/taiga/houses"), "monobank:village/houses/taiga_vault", StructureTemplatePool.Projection.RIGID, vaultWeight);
        VillageStructures.addStructureToPoolLegacy((Registry<StructureTemplatePool>)templatePools, (Holder<StructureProcessorList>)streetPlainsProcessorList, new ResourceLocation("minecraft:village/desert/streets"), "monobank:village/streets/desert_straight_fix_01", StructureTemplatePool.Projection.TERRAIN_MATCHING, vaultWeight);
        VillageStructures.addStructureToPoolSingle((Registry<StructureTemplatePool>)templatePools, (Holder<StructureProcessorList>)mossify10ProcessorList, new ResourceLocation("minecraft:village/desert/houses"), "monobank:village/houses/desert_vault", StructureTemplatePool.Projection.RIGID, vaultWeight);
        VillageStructures.addStructureToPoolLegacy((Registry<StructureTemplatePool>)templatePools, (Holder<StructureProcessorList>)streetPlainsProcessorList, new ResourceLocation("minecraft:village/snowy/streets"), "monobank:village/streets/snowy_straight_fix_01", StructureTemplatePool.Projection.TERRAIN_MATCHING, vaultWeight);
        VillageStructures.addStructureToPoolSingle((Registry<StructureTemplatePool>)templatePools, (Holder<StructureProcessorList>)mossify10ProcessorList, new ResourceLocation("minecraft:village/snowy/houses"), "monobank:village/houses/snowy_vault", StructureTemplatePool.Projection.RIGID, vaultWeight);
        VillageStructures.addStructureToPoolLegacy((Registry<StructureTemplatePool>)templatePools, (Holder<StructureProcessorList>)streetPlainsProcessorList, new ResourceLocation("minecraft:village/savanna/streets"), "monobank:village/streets/savanna_straight_fix_01", StructureTemplatePool.Projection.TERRAIN_MATCHING, vaultWeight);
        VillageStructures.addStructureToPoolSingle((Registry<StructureTemplatePool>)templatePools, (Holder<StructureProcessorList>)mossify10ProcessorList, new ResourceLocation("minecraft:village/savanna/houses"), "monobank:village/houses/savanna_vault", StructureTemplatePool.Projection.RIGID, vaultWeight);
    }

    private static void addStructureToPoolLegacy(Registry<StructureTemplatePool> templatePoolRegistry, Holder<StructureProcessorList> processorListHolder, ResourceLocation poolRL, String nbtPieceRL, StructureTemplatePool.Projection projection, int weight) {
        Logger logger = LogUtils.getLogger();
        StructureTemplatePool pool = (StructureTemplatePool)templatePoolRegistry.m_7745_(poolRL);
        if (pool == null) {
            logger.error("Pool '{}' not found.", (Object)poolRL);
            return;
        }
        SinglePoolElement piece = (SinglePoolElement)SinglePoolElement.m_210512_((String)nbtPieceRL, processorListHolder).apply(projection);
        VillageStructures.addPieceToPool(piece, pool, weight);
    }

    private static void addStructureToPoolSingle(Registry<StructureTemplatePool> templatePoolRegistry, Holder<StructureProcessorList> processorListHolder, ResourceLocation poolRL, String nbtPieceRL, StructureTemplatePool.Projection projection, int weight) {
        Logger logger = LogUtils.getLogger();
        StructureTemplatePool pool = (StructureTemplatePool)templatePoolRegistry.m_7745_(poolRL);
        if (pool == null) {
            logger.error("Pool '{}' not found.", (Object)poolRL);
            return;
        }
        SinglePoolElement piece = (SinglePoolElement)SinglePoolElement.m_210531_((String)nbtPieceRL, processorListHolder).apply(projection);
        VillageStructures.addPieceToPool(piece, pool, weight);
    }

    private static void addPieceToPool(SinglePoolElement piece, StructureTemplatePool pool, int weight) {
        for (int i = 0; i < weight; ++i) {
            pool.f_210560_.add((Object)piece);
        }
        ArrayList<Pair> listOfPieceEntries = new ArrayList<Pair>(pool.f_210559_);
        listOfPieceEntries.add(new Pair((Object)piece, (Object)weight));
        pool.f_210559_ = listOfPieceEntries;
    }
}

