/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.mixins;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.mehvahdjukaar.moonlight.api.map.CustomMapData;
import net.mehvahdjukaar.moonlight.api.map.CustomMapDecoration;
import net.mehvahdjukaar.moonlight.api.map.ExpandedMapData;
import net.mehvahdjukaar.moonlight.api.map.markers.MapBlockMarker;
import net.mehvahdjukaar.moonlight.api.map.type.MapDecorationType;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.map.MapDataInternal;
import net.mehvahdjukaar.moonlight.core.misc.IHoldingPlayerExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.maps.MapBanner;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MapItemSavedData.class})
public abstract class MapDataMixin
extends SavedData
implements ExpandedMapData {
    @Final
    @Shadow
    public byte f_77890_;
    @Final
    @Shadow
    Map<String, MapDecoration> f_77894_;
    @Shadow
    @Final
    private Map<String, MapBanner> f_77897_;
    @Final
    @Shadow
    public int f_77885_;
    @Final
    @Shadow
    public int f_77886_;
    @Shadow
    @Final
    private List<MapItemSavedData.HoldingPlayer> f_77893_;
    @Unique
    public Map<String, CustomMapDecoration> moonlight$customDecorations = Maps.newLinkedHashMap();
    @Unique
    private final Map<String, MapBlockMarker<?>> moonlight$customMapMarkers = Maps.newHashMap();
    @Unique
    public final Map<ResourceLocation, CustomMapData<?>> moonlight$customData = new LinkedHashMap();

    @Override
    public void setCustomDecorationsDirty() {
        this.m_77762_();
        this.f_77893_.forEach(h -> ((IHoldingPlayerExtension)h).moonlight$setCustomMarkersDirty());
    }

    @Override
    public <H extends CustomMapData.DirtyCounter> void setCustomDataDirty(CustomMapData.Type<?> type, Consumer<H> dirtySetter) {
        this.m_77762_();
        this.f_77893_.forEach(h -> ((IHoldingPlayerExtension)h).moonlight$setCustomDataDirty(type, dirtySetter));
    }

    @Override
    public Map<ResourceLocation, CustomMapData<?>> getCustomData() {
        return this.moonlight$customData;
    }

    @Override
    public Map<String, CustomMapDecoration> getCustomDecorations() {
        return this.moonlight$customDecorations;
    }

    @Override
    public Map<String, MapBlockMarker<?>> getCustomMarkers() {
        return this.moonlight$customMapMarkers;
    }

    @Override
    public int getVanillaDecorationSize() {
        return this.f_77894_.size();
    }

    @Override
    public <M extends MapBlockMarker<?>> void addCustomMarker(M marker) {
        Object decoration = marker.createDecorationFromMarker((MapItemSavedData)this);
        if (decoration != null) {
            this.moonlight$customDecorations.put(marker.getMarkerId(), (CustomMapDecoration)decoration);
            if (marker.shouldSave()) {
                this.moonlight$customMapMarkers.put(marker.getMarkerId(), marker);
            }
            this.setCustomDecorationsDirty();
        }
    }

    @Override
    public boolean removeCustomMarker(String key) {
        this.moonlight$customDecorations.remove(key);
        if (this.moonlight$customMapMarkers.containsKey(key)) {
            this.moonlight$customMapMarkers.remove(key);
            this.setCustomDecorationsDirty();
            return true;
        }
        return false;
    }

    @Override
    public MapItemSavedData copy() {
        MapItemSavedData newData = MapItemSavedData.m_164807_((CompoundTag)this.m_7176_(new CompoundTag()));
        newData.m_77762_();
        return newData;
    }

    @Override
    public void resetCustomDecoration() {
        if (!this.f_77897_.isEmpty() || !this.moonlight$customMapMarkers.isEmpty()) {
            this.setCustomDecorationsDirty();
        }
        for (String key : this.moonlight$customMapMarkers.keySet()) {
            this.moonlight$customDecorations.remove(key);
        }
        this.moonlight$customMapMarkers.clear();
        for (String key : this.f_77897_.keySet()) {
            this.f_77894_.remove(key);
        }
        this.f_77897_.clear();
    }

    @Override
    public boolean toggleCustomDecoration(LevelAccessor world, BlockPos pos) {
        if (world.m_5776_()) {
            List<MapBlockMarker<?>> markers = MapDataInternal.getMarkersFromWorld((BlockGetter)world, pos);
            return !markers.isEmpty();
        }
        double d0 = (double)pos.m_123341_() + 0.5;
        double d1 = (double)pos.m_123343_() + 0.5;
        int i = 1 << this.f_77890_;
        double d2 = (d0 - (double)this.f_77885_) / (double)i;
        double d3 = (d1 - (double)this.f_77886_) / (double)i;
        if (d2 >= -63.0 && d3 >= -63.0 && d2 <= 63.0 && d3 <= 63.0) {
            List<MapBlockMarker<?>> markers = MapDataInternal.getMarkersFromWorld((BlockGetter)world, pos);
            boolean changed = false;
            for (MapBlockMarker<?> marker : markers) {
                if (marker == null) continue;
                String id = marker.getMarkerId();
                if (marker.equals(this.moonlight$customMapMarkers.get(id))) {
                    this.removeCustomMarker(id);
                } else {
                    this.addCustomMarker(marker);
                }
                changed = true;
            }
            return changed;
        }
        return false;
    }

    @Inject(method={"locked"}, at={@At(value="RETURN")})
    public void locked(CallbackInfoReturnable<MapItemSavedData> cir) {
        MapItemSavedData data = (MapItemSavedData)cir.getReturnValue();
        if (data instanceof ExpandedMapData) {
            ExpandedMapData expandedMapData = (ExpandedMapData)data;
            expandedMapData.getCustomMarkers().putAll(this.getCustomMarkers());
            expandedMapData.getCustomDecorations().putAll(this.getCustomDecorations());
        }
        this.moonlight$copyCustomData(data);
    }

    @Inject(method={"scaled"}, at={@At(value="RETURN")})
    public void scaled(CallbackInfoReturnable<MapItemSavedData> cir) {
        MapItemSavedData data = (MapItemSavedData)cir.getReturnValue();
        this.moonlight$copyCustomData(data);
    }

    @Unique
    private void moonlight$copyCustomData(MapItemSavedData data) {
        if (data instanceof ExpandedMapData) {
            ExpandedMapData ed = (ExpandedMapData)data;
            for (Map.Entry<ResourceLocation, CustomMapData<?>> d : this.moonlight$customData.entrySet()) {
                CustomMapData<?> v = d.getValue();
                if (!v.persistOnCopyOrLock()) continue;
                CompoundTag t = new CompoundTag();
                v.save(t);
                ed.getCustomData().get(d.getKey()).load(t);
            }
        }
    }

    @Inject(method={"tickCarriedBy"}, at={@At(value="TAIL")})
    public void tickCarriedBy(Player player, ItemStack stack, CallbackInfo ci) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128425_("CustomDecorations", 9)) {
            ListTag listTag = tag.m_128437_("CustomDecorations", 10);
            for (int j = 0; j < listTag.size(); ++j) {
                CompoundTag com = listTag.m_128728_(j);
                if (this.f_77894_.containsKey(com.m_128461_("id"))) continue;
                String name = com.m_128461_("type");
                MapDecorationType<CustomMapDecoration, ?> type = MapDataInternal.get(name);
                if (type != null) {
                    BlockPos pos = new BlockPos(com.m_128451_("x"), 64, com.m_128451_("z"));
                    Object marker = type.createEmptyMarker();
                    ((MapBlockMarker)marker).setPos(pos);
                    this.addCustomMarker((MapBlockMarker)marker);
                    continue;
                }
                Moonlight.LOGGER.warn("Failed to load map decoration " + name + ". Skipping it");
            }
        }
    }

    @Inject(method={"load"}, at={@At(value="RETURN")})
    private static void load(CompoundTag compound, CallbackInfoReturnable<MapItemSavedData> cir) {
        MapItemSavedData data = (MapItemSavedData)cir.getReturnValue();
        if (compound.m_128441_("customMarkers") && data instanceof ExpandedMapData) {
            ExpandedMapData mapData = (ExpandedMapData)data;
            ListTag listNBT = compound.m_128437_("customMarkers", 10);
            for (int j = 0; j < listNBT.size(); ++j) {
                MapBlockMarker<?> marker = MapDataInternal.readWorldMarker(listNBT.m_128728_(j));
                if (marker == null) continue;
                mapData.getCustomMarkers().put(marker.getMarkerId(), marker);
                mapData.addCustomMarker(marker);
            }
            mapData.getCustomData().values().forEach(customMapData -> customMapData.load(compound));
        }
    }

    @Inject(method={"save"}, at={@At(value="RETURN")})
    public void save(CompoundTag tag, CallbackInfoReturnable<CompoundTag> cir) {
        CompoundTag com = (CompoundTag)cir.getReturnValue();
        ListTag listNBT = new ListTag();
        for (MapBlockMarker<?> marker : this.moonlight$customMapMarkers.values()) {
            if (!marker.shouldSave()) continue;
            CompoundTag com2 = new CompoundTag();
            com2.m_128365_(marker.getTypeId(), (Tag)marker.saveToNBT(new CompoundTag()));
            listNBT.add((Object)com2);
        }
        com.m_128365_("customMarkers", (Tag)listNBT);
        this.moonlight$customData.forEach((s, o) -> o.save(tag));
    }

    @Inject(method={"checkBanners"}, at={@At(value="TAIL")})
    public void checkCustomDeco(BlockGetter world, int x, int z, CallbackInfo ci) {
        ArrayList<String> toRemove = new ArrayList<String>();
        ArrayList toAdd = new ArrayList();
        for (Map.Entry<String, MapBlockMarker<?>> e : this.moonlight$customMapMarkers.entrySet()) {
            MapBlockMarker<?> marker = e.getValue();
            if (marker.getPos().m_123341_() != x || marker.getPos().m_123343_() != z || !marker.shouldRefresh()) continue;
            Object newMarker = marker.getType().getWorldMarkerFromWorld(world, marker.getPos());
            String id = e.getKey();
            if (newMarker == null) {
                toRemove.add(id);
                continue;
            }
            if (Objects.equals(marker, newMarker)) continue;
            toRemove.add(id);
            toAdd.add(newMarker);
        }
        toRemove.forEach(this::removeCustomMarker);
        toAdd.forEach(this::addCustomMarker);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    public void initCustomData(int i, int j, byte b, boolean bl, boolean bl2, boolean bl3, ResourceKey resourceKey, CallbackInfo ci) {
        for (CustomMapData.Type<?> d : MapDataInternal.CUSTOM_MAP_DATA_TYPES.values()) {
            this.moonlight$customData.put(d.id(), (CustomMapData)d.factory().get());
        }
    }
}

