/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.client.texture_renderer;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.mehvahdjukaar.moonlight.api.client.texture_renderer.FrameBufferBackedDynamicTexture;
import net.mehvahdjukaar.moonlight.api.client.texture_renderer.TickableFrameBufferBackedDynamicTexture;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class RenderedTexturesManager {
    private static final LoadingCache<ResourceLocation, FrameBufferBackedDynamicTexture> TEXTURE_CACHE = CacheBuilder.newBuilder().removalListener(i -> RenderSystem.m_69879_(((FrameBufferBackedDynamicTexture)((Object)((Object)i.getValue())))::close)).expireAfterAccess(2L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<ResourceLocation, FrameBufferBackedDynamicTexture>(){

        public FrameBufferBackedDynamicTexture load(ResourceLocation key) {
            return null;
        }
    });

    public static void clearCache() {
        TEXTURE_CACHE.invalidateAll();
    }

    public static FrameBufferBackedDynamicTexture requestTexture(ResourceLocation id, int textureSize, Consumer<FrameBufferBackedDynamicTexture> textureDrawingFunction, boolean updateEachFrame) {
        FrameBufferBackedDynamicTexture texture = (FrameBufferBackedDynamicTexture)((Object)TEXTURE_CACHE.getIfPresent((Object)id));
        if (texture == null) {
            texture = updateEachFrame ? new TickableFrameBufferBackedDynamicTexture(id, textureSize, textureDrawingFunction) : new FrameBufferBackedDynamicTexture(id, textureSize, textureDrawingFunction);
            TEXTURE_CACHE.put((Object)id, (Object)texture);
            RenderSystem.m_69879_(texture::initialize);
        }
        return texture;
    }

    @Deprecated(forRemoval=true)
    public static FrameBufferBackedDynamicTexture getFlatItemStackTexture(ResourceLocation res, ItemStack stack, int size) {
        return RenderedTexturesManager.requestFlatItemStackTexture(res, stack, size);
    }

    public static FrameBufferBackedDynamicTexture requestFlatItemStackTexture(ResourceLocation res, ItemStack stack, int size) {
        return RenderedTexturesManager.requestTexture(res, size, t -> RenderedTexturesManager.drawItem(t, stack), true);
    }

    public static FrameBufferBackedDynamicTexture requestFlatItemTexture(Item item, int size) {
        return RenderedTexturesManager.requestFlatItemTexture(item, size, null);
    }

    public static FrameBufferBackedDynamicTexture requestFlatItemTexture(Item item, int size, @Nullable Consumer<NativeImage> postProcessing) {
        ResourceLocation id = Moonlight.res(Utils.getID(item).toString().replace(":", "/") + "/" + size);
        return RenderedTexturesManager.requestFlatItemTexture(id, item, size, postProcessing, false);
    }

    public static FrameBufferBackedDynamicTexture requestFlatItemTexture(ResourceLocation id, Item item, int size, @Nullable Consumer<NativeImage> postProcessing) {
        return RenderedTexturesManager.requestFlatItemTexture(id, item, size, postProcessing, false);
    }

    public static FrameBufferBackedDynamicTexture requestFlatItemTexture(ResourceLocation id, Item item, int size, @Nullable Consumer<NativeImage> postProcessing, boolean updateEachFrame) {
        return RenderedTexturesManager.requestTexture(id, size, t -> {
            RenderedTexturesManager.drawItem(t, item.m_7968_());
            if (postProcessing != null) {
                t.download();
                NativeImage img = t.getPixels();
                postProcessing.accept(img);
                t.upload();
            }
        }, updateEachFrame);
    }

    public static void drawItem(FrameBufferBackedDynamicTexture tex, ItemStack stack) {
        RenderedTexturesManager.drawAsInGUI(tex, s -> {
            ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
            itemRenderer.m_115123_(stack, 0, 0);
        });
    }

    public static void drawAsInWorld(FrameBufferBackedDynamicTexture tex, Consumer<PoseStack> drawFunction) {
        RenderedTexturesManager.drawAsInGUI(tex, s -> {
            float scale = 0.0625f;
            s.m_85841_(scale, scale, scale);
            drawFunction.accept((PoseStack)s);
        });
    }

    public static void drawAsInGUI(FrameBufferBackedDynamicTexture tex, Consumer<PoseStack> drawFunction) {
        Minecraft mc = Minecraft.m_91087_();
        RenderTarget frameBuffer = tex.getFrameBuffer();
        frameBuffer.m_83954_(Minecraft.f_91002_);
        frameBuffer.m_83947_(true);
        int size = 16;
        Matrix4f oldProjection = RenderSystem.m_157192_();
        Matrix4f matrix4f = Matrix4f.m_162203_((float)0.0f, (float)size, (float)0.0f, (float)size, (float)1000.0f, (float)3000.0f);
        RenderSystem.m_157425_((Matrix4f)matrix4f);
        PoseStack posestack = RenderSystem.m_157191_();
        posestack.m_85836_();
        posestack.m_166856_();
        posestack.m_85837_(0.0, 0.0, -2000.0);
        RenderSystem.m_157182_();
        Lighting.m_84931_();
        drawFunction.accept(posestack);
        posestack.m_85849_();
        RenderSystem.m_157182_();
        RenderSystem.m_157425_((Matrix4f)oldProjection);
        mc.m_91385_().m_83947_(true);
    }

    private static Matrix4f getProjectionMatrix(double pFov, int size, int renderDistance) {
        PoseStack posestack = new PoseStack();
        posestack.m_85850_().m_85861_().m_27624_();
        float zoom = 1.0f;
        float zoomX = 1.0f;
        float zoomY = 1.0f;
        if (zoom != 1.0f) {
            posestack.m_85837_((double)zoomX, (double)(-zoomY), 0.0);
            posestack.m_85841_(zoom, zoom, 1.0f);
        }
        posestack.m_85850_().m_85861_().m_27644_(Matrix4f.m_27625_((double)pFov, (float)((float)size / (float)size), (float)0.05f, (float)((float)renderDistance * 4.0f)));
        return posestack.m_85850_().m_85861_();
    }

    private static void drawItem2(FrameBufferBackedDynamicTexture tex, BlockPos mirrorPos, Direction mirrorDir, float partialTicks) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return;
        }
        RenderTarget frameBuffer = tex.getFrameBuffer();
        frameBuffer.m_83954_(Minecraft.f_91002_);
        frameBuffer.m_83947_(true);
        int size = tex.getWidth();
        GameRenderer gameRenderer = mc.f_91063_;
        LevelRenderer levelRenderer = mc.f_91060_;
        PoseStack posestack = RenderSystem.m_157191_();
        posestack.m_85836_();
        RenderSystem.m_157182_();
        RenderSystem.m_69421_((int)16640, (boolean)Minecraft.f_91002_);
        FogRenderer.m_109017_();
        RenderSystem.m_69493_();
        RenderSystem.m_69481_();
        RenderSystem.m_69949_((int)0, (int)0, (int)size, (int)size);
        gameRenderer.m_172718_(1.0f, 0.0f, 0.0f);
        levelRenderer.m_109769_();
        posestack.m_85849_();
        RenderSystem.m_157182_();
        mc.m_91385_().m_83947_(true);
    }
}

