/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.fluids;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.mehvahdjukaar.moonlight.api.fluids.FoodProvider;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class FoodProviders {
    private static final FoodProvider MILK = new FoodProvider(Items.f_42455_, 3){

        @Override
        public boolean consume(Player player, Level world, @Nullable Consumer<ItemStack> nbtApplier) {
            ItemStack stack = this.food.m_7968_();
            if (nbtApplier != null) {
                nbtApplier.accept(stack);
            }
            for (MobEffectInstance effect : player.m_21221_().values()) {
                if (!ForgeHelper.isCurativeItem(stack, effect)) continue;
                player.m_21195_(effect.m_19544_());
                break;
            }
            player.m_5496_(this.food.m_6023_(), 1.0f, 1.0f);
            return true;
        }
    };
    private static final FoodProvider SUS_STEW = new FoodProvider(Items.f_42718_, 2){

        @Override
        public boolean consume(Player player, Level world, @Nullable Consumer<ItemStack> nbtApplier) {
            FoodProperties foodProperties;
            ItemStack stack = this.food.m_7968_();
            if (nbtApplier != null) {
                nbtApplier.accept(stack);
            }
            if ((foodProperties = this.food.m_41473_()) != null && player.m_36391_(false)) {
                CompoundTag tag = stack.m_41783_();
                if (tag != null && tag.m_128425_("Effects", 9)) {
                    ListTag effects = tag.m_128437_("Effects", 10);
                    for (int i = 0; i < effects.size(); ++i) {
                        MobEffect effect;
                        int j = 160;
                        CompoundTag effectsCompound = effects.m_128728_(i);
                        if (effectsCompound.m_128425_("EffectDuration", 3)) {
                            j = effectsCompound.m_128451_("EffectDuration") / this.divider;
                        }
                        if ((effect = MobEffect.m_19453_((int)effectsCompound.m_128445_("EffectId"))) == null) continue;
                        player.m_7292_(new MobEffectInstance(effect, j));
                    }
                }
                player.m_36324_().m_38707_(foodProperties.m_38744_() / this.divider, foodProperties.m_38745_() / (float)this.divider);
                player.m_5496_(this.food.m_6023_(), 1.0f, 1.0f);
                return true;
            }
            return false;
        }
    };
    private static final FoodProvider XP = new FoodProvider(Items.f_42612_, 1){

        @Override
        public boolean consume(Player player, Level world, @Nullable Consumer<ItemStack> nbtApplier) {
            player.m_6756_(Utils.getXPinaBottle(1, world.f_46441_));
            player.m_5496_(SoundEvents.f_11871_, 1.0f, 1.0f);
            return true;
        }
    };
    static final Map<Item, FoodProvider> CUSTOM_PROVIDERS = (Map)Util.m_137537_(() -> {
        IdentityHashMap<Item, FoodProvider> map = new IdentityHashMap<Item, FoodProvider>();
        map.put(Items.f_41852_, FoodProvider.EMPTY);
        map.put(Items.f_42718_, SUS_STEW);
        map.put(Items.f_42455_, MILK);
        map.put(Items.f_42612_, XP);
        return map;
    });
}

