/*
 * Decompiled with CFR 0.152.
 */
package com.tom.morewires;

import com.tom.morewires.Config;
import com.tom.morewires.MoreImmersiveWiresClient;
import com.tom.morewires.SimpleWireTypeDefinition;
import com.tom.morewires.WireTypeDefinition;
import com.tom.morewires.compat.ae.AEDenseWireDefinition;
import com.tom.morewires.compat.ae.AEWireDefinition;
import com.tom.morewires.compat.cc.CCWireDefinition;
import com.tom.morewires.compat.ftbic.FTBICWireDefinition;
import com.tom.morewires.compat.ic2.IC2WireDefinition;
import com.tom.morewires.compat.id.IntegratedDynamicsWireDefinition;
import com.tom.morewires.compat.rs.RSWireDefinition;
import com.tom.morewires.compat.top.TheOneProbeHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="more_immersive_wires")
public class MoreImmersiveWires {
    public static final String modid = "more_immersive_wires";
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"more_immersive_wires");
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"more_immersive_wires");
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"more_immersive_wires");
    public static final Map<BlockEntityType<?>, WireTypeDefinition.RelayInfo> WIRE_TYPES = new HashMap();
    public static final List<Wire> ALL_WIRES = new ArrayList<Wire>();
    public static final String AE = "ae2";
    public static final String RS = "refinedstorage";
    public static final String ID = "integrateddynamics";
    public static final String CC = "computercraft";
    public static final String FTBIC = "ftbic";
    public static final String IC2 = "ic2";
    public static final Wire AE_WIRE = new Wire("ae2", () -> AEWireDefinition::new);
    public static final Wire AE_DENSE_WIRE = new Wire("ae2", () -> AEDenseWireDefinition::new);
    public static final Wire RS_WIRE = new Wire("refinedstorage", () -> RSWireDefinition::new);
    public static final Wire ID_WIRE = new Wire("integrateddynamics", () -> IntegratedDynamicsWireDefinition::new);
    public static final Wire CC_WIRE = new Wire("computercraft", () -> CCWireDefinition::new);
    public static final Wire FTBIC_WIRE_LV = new Wire("ftbic", () -> FTBICWireDefinition::lv);
    public static final Wire FTBIC_WIRE_MV = new Wire("ftbic", () -> FTBICWireDefinition::mv);
    public static final Wire FTBIC_WIRE_HV = new Wire("ftbic", () -> FTBICWireDefinition::hv);
    public static final Wire FTBIC_WIRE_EV = new Wire("ftbic", () -> FTBICWireDefinition::ev);
    public static final Wire FTBIC_WIRE_IV = new Wire("ftbic", () -> FTBICWireDefinition::iv);
    public static final Wire IC2_WIRE_ULV = new Wire("ic2", () -> IC2WireDefinition::ulv);
    public static final Wire IC2_WIRE_LV = new Wire("ic2", () -> IC2WireDefinition::lv);
    public static final Wire IC2_WIRE_MV = new Wire("ic2", () -> IC2WireDefinition::mv);
    public static final Wire IC2_WIRE_HV = new Wire("ic2", () -> IC2WireDefinition::hv);
    public static final Wire IC2_WIRE_EV = new Wire("ic2", () -> IC2WireDefinition::ev);
    public static final Wire IC2_WIRE_IV = new Wire("ic2", () -> IC2WireDefinition::iv);
    public static final Wire IC2_WIRE_LUV = new Wire("ic2", () -> IC2WireDefinition::luv);
    public static final Wire[] IC2_WIRES = new Wire[]{IC2_WIRE_ULV, IC2_WIRE_LV, IC2_WIRE_MV, IC2_WIRE_HV, IC2_WIRE_EV, IC2_WIRE_IV, IC2_WIRE_LUV};
    public static final Logger LOGGER = LogManager.getLogger();
    public static Map<String, String> MODID_NAME_LOOKUP = Collections.emptyMap();
    public static final CreativeModeTab MOD_TAB = new CreativeModeTab("more_immersive_wires.tab"){

        @OnlyIn(value=Dist.CLIENT)
        public ItemStack m_6976_() {
            return ALL_WIRES.stream().flatMap(w -> w.wireTypeDef.getWireCoils().stream()).map(w -> new ItemStack((ItemLike)w.getCoilItem().get())).findFirst().orElse(new ItemStack((ItemLike)Items.f_42451_));
        }
    };

    public MoreImmersiveWires() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> MoreImmersiveWiresClient::preInit);
        ALL_WIRES.forEach(Wire::init);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Config.clientSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.commonSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.serverSpec);
        FMLJavaModLoadingContext.get().getModEventBus().register(Config.class);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        BLOCKS.register(bus);
        ITEMS.register(bus);
        BLOCK_ENTITIES.register(bus);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void setup(FMLCommonSetupEvent event) {
        LOGGER.info("More Immersive Wires Setup starting");
        ALL_WIRES.forEach(Wire::setup);
        MODID_NAME_LOOKUP = ModList.get().getMods().stream().collect(Collectors.toMap(IModInfo::getModId, IModInfo::getDisplayName));
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        MoreImmersiveWiresClient.clientSetup();
    }

    public void enqueueIMC(InterModEnqueueEvent e) {
        if (ModList.get().isLoaded("theoneprobe")) {
            InterModComms.sendTo((String)"theoneprobe", (String)"getTheOneProbe", () -> TheOneProbeHandler.create());
        }
    }

    public static <B extends Block> RegistryObject<B> blockWithItem(String name, Supplier<B> create) {
        RegistryObject re = BLOCKS.register(name, create);
        ITEMS.register(name, () -> new BlockItem((Block)re.get(), new Item.Properties().m_41491_(MOD_TAB)));
        return re;
    }

    public static <B extends Block, I extends Item> RegistryObject<B> blockWithItem(String name, Supplier<B> create, Function<Block, I> createItem) {
        RegistryObject re = BLOCKS.register(name, create);
        ITEMS.register(name, () -> (Item)createItem.apply((Block)re.get()));
        return re;
    }

    public static RegistryObject<Item> materialItem(String name) {
        return ITEMS.register(name, () -> new Item(new Item.Properties().m_41491_(MOD_TAB)));
    }

    @SafeVarargs
    public static <BE extends BlockEntity> RegistryObject<BlockEntityType<BE>> blockEntity(String name, BlockEntityType.BlockEntitySupplier<? extends BE> create, RegistryObject<? extends Block> ... blocks) {
        return BLOCK_ENTITIES.register(name, () -> BlockEntityType.Builder.m_155273_((BlockEntityType.BlockEntitySupplier)create, (Block[])((Block[])Arrays.stream(blocks).map(RegistryObject::get).toArray(Block[]::new))).m_58966_(null));
    }

    public static class Wire {
        public final String modid;
        public WireTypeDefinition<?> wireTypeDef;

        public Wire(String modid, Supplier<Supplier<WireTypeDefinition<?>>> createDef) {
            this.modid = modid;
            if (ModList.get().isLoaded(modid)) {
                ALL_WIRES.add(this);
                this.wireTypeDef = createDef.get().get();
            }
        }

        public void init() {
            this.wireTypeDef.init();
        }

        public void setup() {
            this.wireTypeDef.setup(this);
        }

        public void config(ForgeConfigSpec.Builder builder) {
            this.wireTypeDef.config(builder);
        }

        public SimpleWireTypeDefinition<?> simple() {
            return (SimpleWireTypeDefinition)this.wireTypeDef;
        }
    }
}

