/*
 * Decompiled with CFR 0.152.
 */
package com.tom.morewires.compat.ftbic;

import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.localhandlers.EnergyTransferHandler;
import blusunrize.immersiveengineering.api.wires.localhandlers.ILocalHandlerConstructor;
import com.tom.morewires.MoreImmersiveWires;
import com.tom.morewires.SimpleWireTypeDefinition;
import com.tom.morewires.compat.ftbic.FTBICConnectorBlock;
import com.tom.morewires.compat.ftbic.FTBICConnectorBlockEntity;
import com.tom.morewires.compat.ftbic.FTBICTOP;
import com.tom.morewires.compat.top.TheOneProbeHandler;
import dev.ftb.mods.ftbic.FTBICConfig;
import dev.ftb.mods.ftbic.block.CableBlock;
import dev.ftb.mods.ftbic.util.EnergyTier;
import dev.ftb.mods.ftbic.util.FTBICUtils;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.RegistryObject;

public class FTBICWireDefinition
extends SimpleWireTypeDefinition<FTBICConnectorBlockEntity> {
    public static final int ZAP_MULT = 10;
    public static RegistryObject<Item> ENERGY_ALLOY;
    private boolean tall;
    private boolean thick;
    private final Supplier<EnergyTier> tierSup;
    private EnergyTier tier;
    public int energyCapacity;

    private FTBICWireDefinition(String name, String localized, int color, boolean tall, boolean thick, Supplier<EnergyTier> tier) {
        super(name, localized, color);
        this.tall = tall;
        this.thick = thick;
        this.tierSup = tier;
    }

    public static FTBICWireDefinition lv() {
        return new FTBICWireDefinition("ftbic_lv", "LV", 0x111111, false, false, () -> EnergyTier.LV);
    }

    public static FTBICWireDefinition mv() {
        return new FTBICWireDefinition("ftbic_mv", "MV", 0x222222, false, true, () -> EnergyTier.MV);
    }

    public static FTBICWireDefinition hv() {
        return new FTBICWireDefinition("ftbic_hv", "HV", 0x333311, true, false, () -> EnergyTier.HV);
    }

    public static FTBICWireDefinition ev() {
        return new FTBICWireDefinition("ftbic_ev", "EV", 0x111144, true, true, () -> EnergyTier.EV);
    }

    public static FTBICWireDefinition iv() {
        return new FTBICWireDefinition("ftbic_iv", "IV", 0xEEEEEE, true, false, () -> EnergyTier.IV){

            @Override
            public void init() {
                super.init();
                ENERGY_ALLOY = MoreImmersiveWires.materialItem("ftbic_energy_alloy");
            }
        };
    }

    @Override
    public void setup(MoreImmersiveWires.Wire w) {
        super.setup(w);
        this.tier = this.tierSup.get();
        this.energyCapacity = Mth.m_14107_((double)((Double)this.tier.transferRate.get() * 10.0));
    }

    @Override
    protected SimpleWireTypeDefinition.WireBase createWire() {
        return new FTBICWire();
    }

    @Override
    protected ILocalHandlerConstructor createLocalHandler() {
        return EnergyTransferHandler::new;
    }

    @Override
    public boolean isCable(BlockGetter level, BlockPos pos) {
        return level.m_8055_(pos).m_60734_() instanceof CableBlock;
    }

    @Override
    public Block makeBlock(RegistryObject<BlockEntityType<FTBICConnectorBlockEntity>> type) {
        return new FTBICConnectorBlock(type, this::isCable);
    }

    @Override
    public FTBICConnectorBlockEntity createBE(BlockPos pos, BlockState state) {
        return new FTBICConnectorBlockEntity(this, pos, state);
    }

    @Override
    public boolean isTallConnector() {
        return this.tall;
    }

    @Override
    public boolean isThickWire() {
        return this.thick;
    }

    @Override
    public boolean isExTallRelay() {
        return this.tall;
    }

    @Override
    protected void appendHoverText(List<Component> list) {
        list.add((Component)Component.m_237110_((String)"ftbic.max_input", (Object[])new Object[]{FTBICUtils.formatEnergy((double)((Double)this.tier.transferRate.get())).m_130946_("/t").m_130940_(ChatFormatting.GRAY)}).m_130940_(ChatFormatting.DARK_GRAY));
    }

    @Override
    public void appendHoverTextConnector(Object id, ItemStack stack, Level world, List<Component> tooltip, TooltipFlag advanced) {
        Double feRatio;
        super.appendHoverTextConnector(id, stack, world, tooltip, advanced);
        if (id != null && (feRatio = (Double)FTBICConfig.ENERGY.ZAP_TO_FE_CONVERSION_RATE.get()) > 0.0) {
            tooltip.add((Component)Component.m_237110_((String)"ftbic.zap_to_fe_conversion", (Object[])new Object[]{FTBICConfig.ENERGY_FORMAT, feRatio}).m_130940_(ChatFormatting.DARK_GRAY));
        }
    }

    static {
        if (ModList.get().isLoaded("theoneprobe")) {
            TheOneProbeHandler.add(new FTBICTOP());
        }
    }

    private class FTBICWire
    extends SimpleWireTypeDefinition.WireBase
    implements EnergyTransferHandler.IEnergyWire {
        private FTBICWire() {
            super(FTBICWireDefinition.this);
        }

        public int getTransferRate() {
            return FTBICWireDefinition.this.energyCapacity;
        }

        public double getBasicLossRate(Connection c) {
            return 0.0;
        }

        public double getLossRate(Connection c, int transferred) {
            return 0.0;
        }

        public boolean shouldBurn(Connection c, double power) {
            return false;
        }
    }
}

