/*
 * Decompiled with CFR 0.152.
 */
package com.tom.morewires.compat.top;

import com.tom.morewires.CompatConfig;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.NumberFormat;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.apiimpl.elements.ElementProgress;
import mcjty.theoneprobe.items.IEnumConfig;
import net.minecraft.network.chat.Component;
import net.minecraftforge.common.ForgeConfigSpec;

public class BarConfig
implements CompatConfig.ConfigHandler {
    public int barFilledColor = -2293760;
    public int barAlternateFilledColor = -12386304;
    public int barBorderColor = -11184811;
    public int barMode;
    public IEnumConfig<NumberFormat> barFormat;
    private ForgeConfigSpec.IntValue defaultBarMode;
    private ForgeConfigSpec.ConfigValue<String> cfgBarFilledColor;
    private ForgeConfigSpec.ConfigValue<String> cfgBarAlternateFilledColor;
    private ForgeConfigSpec.ConfigValue<String> cfgBarBorderColor;
    private final String groupName;
    private final String type;

    public BarConfig(String groupName, String type) {
        this.groupName = groupName;
        this.type = type;
    }

    @Override
    public void build(ForgeConfigSpec.Builder builder) {
        builder.push(this.groupName);
        this.defaultBarMode = builder.comment("How to display " + this.type + "s: 0 = do not show, 1 = show in a bar, 2 = show as text").defineInRange("showBar", 1, 0, 2);
        this.barFormat = BarConfig.addEnumConfig((ForgeConfigSpec.Builder)builder, (String)"zapFormat", (String)("Format for displaying " + this.type + "s"), (Enum)NumberFormat.COMPACT, (Enum[])new NumberFormat[]{NumberFormat.COMMAS, NumberFormat.COMPACT, NumberFormat.FULL, NumberFormat.NONE});
        this.cfgBarFilledColor = builder.comment("Color for the " + this.type + " bar").define("barFilledColor", (Object)Integer.toHexString(this.barFilledColor));
        this.cfgBarAlternateFilledColor = builder.comment("Alternate color for the " + this.type + " bar").define("barAlternateFilledColor", (Object)Integer.toHexString(this.barAlternateFilledColor));
        this.cfgBarBorderColor = builder.comment("Color for the " + this.type + " bar border").define("barBorderColor", (Object)Integer.toHexString(this.barBorderColor));
        builder.pop();
    }

    @Override
    public void reload() {
        this.barFilledColor = BarConfig.parseColor((String)this.cfgBarFilledColor.get());
        this.barAlternateFilledColor = BarConfig.parseColor((String)this.cfgBarAlternateFilledColor.get());
        this.barBorderColor = BarConfig.parseColor((String)this.cfgBarBorderColor.get());
        this.barMode = (Integer)this.defaultBarMode.get();
    }

    private static <T extends Enum<T>> IEnumConfig<T> addEnumConfig(ForgeConfigSpec.Builder builder, String path, String comment, T def, T ... values) {
        final ForgeConfigSpec.ConfigValue configValue = builder.comment(comment).define(path, (Object)def.name());
        return new IEnumConfig<T>((Enum[])values){
            final /* synthetic */ Enum[] val$values;
            {
                this.val$values = enumArray;
            }

            public T get() {
                String s = (String)configValue.get();
                for (Enum value : this.val$values) {
                    if (!value.name().equals(s)) continue;
                    return value;
                }
                return null;
            }

            public T getDefault() {
                String s = (String)configValue.getDefault();
                for (Enum value : this.val$values) {
                    if (!value.name().equals(s)) continue;
                    return value;
                }
                return null;
            }
        };
    }

    private static int parseColor(String col) {
        try {
            return (int)Long.parseLong(col, 16);
        }
        catch (NumberFormatException e) {
            System.out.println("Config.parseColor");
            return 0;
        }
    }

    public void addBar(IProbeInfo probeInfo, long energy, long cap, Component suffix) {
        if (this.barMode == 1) {
            probeInfo.progress(energy, cap, probeInfo.defaultProgressStyle().suffix(suffix).filledColor(this.barFilledColor).alternateFilledColor(this.barAlternateFilledColor).borderColor(this.barBorderColor).numberFormat((NumberFormat)this.barFormat.get()));
        } else if (this.barMode == 2) {
            probeInfo.text(CompoundText.create().style(TextStyleClass.PROGRESS).text((Component)suffix.m_6881_().m_130946_(": " + ElementProgress.format((long)energy, (NumberFormat)((NumberFormat)this.barFormat.get()), (Component)suffix))));
        }
    }
}

