/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.obscureapi.api;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;

public final class HeartsRenderManager {
    private static final List<Style> REGISTRY = new ArrayList<Style>();
    private static Style STYLE = null;
    private static int tick;

    @Nullable
    public static ResourceLocation getActiveStyle() {
        return STYLE != null ? HeartsRenderManager.STYLE.LOCATION : null;
    }

    public static void register(ResourceLocation location, Predicate<Player> condition) {
        REGISTRY.add(new Style(location, condition));
    }

    public static void onClientTick(@Nonnull TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (tick++ >= 10) {
            tick = 0;
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return;
            }
            for (Style style : REGISTRY) {
                if (!style.CONDITION.test((Player)player)) continue;
                STYLE = style;
                return;
            }
            STYLE = null;
        }
    }

    private static class Style {
        private final ResourceLocation LOCATION;
        private final Predicate<Player> CONDITION;

        private Style(ResourceLocation location, Predicate<Player> condition) {
            this.LOCATION = location;
            this.CONDITION = condition;
        }
    }
}

