/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.spruceui;

import dev.lambdaurora.spruceui.SprucePositioned;
import dev.lambdaurora.spruceui.widget.SpruceWidget;
import java.util.Objects;

public final class Position
implements SprucePositioned {
    private SprucePositioned anchor;
    private int x = 0;
    private int y = 0;

    protected Position(SprucePositioned anchor) {
        this.anchor = anchor;
    }

    public static Position of(SprucePositioned anchor, int x, int y) {
        return new Position(anchor).move(x, y);
    }

    public static Position of(int x, int y) {
        return Position.of(Position.origin(), x, y);
    }

    public static Position center(SpruceWidget parent, int y) {
        return Position.center(parent, parent.getWidth(), y);
    }

    public static Position center(SprucePositioned anchor, int width, int y) {
        return Position.of(anchor, width / 2, y);
    }

    public static Position center(int width, int y) {
        return Position.of(width / 2, y);
    }

    public static Position origin() {
        return new Position(new SprucePositioned(){});
    }

    public SprucePositioned getAnchor() {
        return this.anchor;
    }

    public void setAnchor(SprucePositioned anchor) {
        this.anchor = anchor;
    }

    @Override
    public int getX() {
        return this.anchor.getX() + this.x;
    }

    @Override
    public int getY() {
        return this.anchor.getY() + this.y;
    }

    public Position move(int x, int y) {
        this.setRelativeX(x);
        this.setRelativeY(y);
        return this;
    }

    public int getRelativeX() {
        return this.x;
    }

    public void setRelativeX(int x) {
        this.x = x;
    }

    public int getRelativeY() {
        return this.y;
    }

    public void setRelativeY(int y) {
        this.y = y;
    }

    public Position copy() {
        return Position.of(this.anchor, this.x, this.y);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Position position = (Position)o;
        return this.getX() == position.getX() && this.getY() == position.getY();
    }

    public int hashCode() {
        return Objects.hash(this.anchor, this.x, this.y);
    }

    public String toString() {
        return "Position{anchor=" + String.valueOf(this.anchor) + ", x=" + this.x + ", y=" + this.y + "}";
    }
}

