/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.spruceui;

import com.google.common.collect.Queues;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.lambdaurora.spruceui.SprucePositioned;
import dev.lambdaurora.spruceui.Tooltipable;
import dev.lambdaurora.spruceui.widget.SpruceWidget;
import java.util.List;
import java.util.Queue;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.ApiStatus;

public class Tooltip
extends GuiComponent
implements SprucePositioned {
    private static final Queue<Tooltip> TOOLTIPS = Queues.newConcurrentLinkedQueue();
    private static boolean delayed = false;
    private final int x;
    private final int y;
    private final List<FormattedCharSequence> tooltip;

    public Tooltip(int x, int y, String tooltip, int parentWidth) {
        this(x, y, FormattedText.m_130775_((String)tooltip), parentWidth);
    }

    public Tooltip(int x, int y, FormattedText tooltip, int parentWidth) {
        this(x, y, Minecraft.m_91087_().f_91062_.m_92923_(tooltip, Math.max(parentWidth * 2 / 3, 200)));
    }

    public Tooltip(int x, int y, List<FormattedCharSequence> tooltip) {
        this.x = x;
        this.y = y;
        this.tooltip = tooltip;
    }

    public static Tooltip create(int x, int y, String tooltip, int parentWidth) {
        return new Tooltip(x, y, tooltip, parentWidth);
    }

    public static Tooltip create(int x, int y, FormattedText tooltip, int parentWidth) {
        return new Tooltip(x, y, tooltip, parentWidth);
    }

    public static Tooltip create(int x, int y, List<FormattedCharSequence> tooltip) {
        return new Tooltip(x, y, tooltip);
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    public boolean shouldRender() {
        return !this.tooltip.isEmpty();
    }

    public void render(Screen screen, PoseStack matrices) {
        screen.m_96617_(matrices, this.tooltip, this.x, this.y);
    }

    public void queue() {
        TOOLTIPS.add(this);
    }

    public static <T extends Tooltipable & SpruceWidget> void queueFor(T widget, int mouseX, int mouseY, int tooltipTicks, IntConsumer tooltipTicksSetter, long lastTick, LongConsumer lastTickSetter) {
        if (((SpruceWidget)widget).isVisible()) {
            widget.getTooltip().ifPresent(tooltip -> {
                long currentRender = System.currentTimeMillis();
                if (lastTick != 0L) {
                    if (currentRender - lastTick >= 20L) {
                        tooltipTicksSetter.accept(tooltipTicks + 1);
                        lastTickSetter.accept(currentRender);
                    }
                } else {
                    lastTickSetter.accept(currentRender);
                }
                if (!((SpruceWidget)((Object)widget)).isFocused() && !((SpruceWidget)((Object)widget)).isMouseHovered()) {
                    tooltipTicksSetter.accept(0);
                }
                if (!tooltip.getString().isEmpty() && tooltipTicks >= 45) {
                    List wrappedTooltipText = Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)tooltip, Math.max(((SpruceWidget)((Object)widget)).getWidth() * 2 / 3, 200));
                    if (((SpruceWidget)((Object)widget)).isMouseHovered()) {
                        Tooltip.create(mouseX, mouseY, wrappedTooltipText).queue();
                    } else if (((SpruceWidget)((Object)widget)).isFocused()) {
                        Tooltip.create(((SpruceWidget)((Object)widget)).getX() - 12, ((SpruceWidget)((Object)widget)).getY() + ((SpruceWidget)((Object)widget)).getHeight() + 16, wrappedTooltipText).queue();
                    }
                }
            });
        }
    }

    @ApiStatus.Internal
    static void setDelayedRender(boolean delayed) {
        Tooltip.delayed = delayed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renderAll(Screen screen, PoseStack matrices) {
        if (delayed) {
            return;
        }
        Queue<Tooltip> queue = TOOLTIPS;
        synchronized (queue) {
            Tooltip tooltip;
            while ((tooltip = TOOLTIPS.poll()) != null) {
                tooltip.render(screen, matrices);
            }
        }
    }
}

