/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.spruceui.option;

import dev.lambdaurora.spruceui.Position;
import dev.lambdaurora.spruceui.option.SpruceOption;
import dev.lambdaurora.spruceui.util.SpruceUtil;
import dev.lambdaurora.spruceui.widget.SpruceWidget;
import dev.lambdaurora.spruceui.widget.text.SpruceNamedTextFieldWidget;
import dev.lambdaurora.spruceui.widget.text.SpruceTextFieldWidget;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Nullable;

public class SpruceIntegerInputOption
extends SpruceOption {
    private final Supplier<Integer> getter;
    private final Consumer<Integer> setter;

    public SpruceIntegerInputOption(String key, Supplier<Integer> getter, Consumer<Integer> setter, @Nullable Component tooltip) {
        super(key);
        this.getter = getter;
        this.setter = setter;
        this.setTooltip(tooltip);
    }

    @Override
    public SpruceWidget createWidget(Position position, int width) {
        SpruceTextFieldWidget textField = new SpruceTextFieldWidget(position, width, 20, this.getPrefix());
        textField.setText(String.valueOf(this.get()));
        textField.setTextPredicate(SpruceTextFieldWidget.INTEGER_INPUT_PREDICATE);
        textField.setRenderTextProvider((displayedText, offset) -> {
            try {
                Integer.parseInt(textField.getText());
                return FormattedCharSequence.m_13714_((String)displayedText, (Style)Style.f_131099_);
            }
            catch (NumberFormatException e) {
                return FormattedCharSequence.m_13714_((String)displayedText, (Style)Style.f_131099_.m_131140_(ChatFormatting.RED));
            }
        });
        textField.setChangedListener(input -> {
            int value = SpruceUtil.parseIntFromString(input);
            this.set(value);
        });
        this.getOptionTooltip().ifPresent(textField::setTooltip);
        return new SpruceNamedTextFieldWidget(textField);
    }

    public void set(int value) {
        this.setter.accept(value);
    }

    public int get() {
        return this.getter.get();
    }
}

