/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.spruceui.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.lambdaurora.spruceui.Position;
import dev.lambdaurora.spruceui.navigation.NavigationDirection;
import dev.lambdaurora.spruceui.widget.SpruceWidget;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSpruceWidget
extends GuiComponent
implements SpruceWidget {
    protected final Minecraft client = Minecraft.m_91087_();
    protected final Position position;
    private boolean visible;
    protected int width;
    protected int height;
    protected boolean active = true;
    protected boolean focused = false;
    protected boolean hovered = false;
    protected boolean wasHovered = false;
    protected boolean dragging = false;
    protected long lastDrag = 0L;

    public AbstractSpruceWidget(Position position) {
        this.position = position;
        this.visible = true;
    }

    @Override
    public Position getPosition() {
        return this.position;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        if (this.focused) {
            return NarratableEntry.NarrationPriority.FOCUSED;
        }
        if (this.hovered) {
            return NarratableEntry.NarrationPriority.HOVERED;
        }
        return NarratableEntry.NarrationPriority.NONE;
    }

    @Override
    public boolean isMouseHovered() {
        return this.hovered;
    }

    @Override
    public boolean isFocused() {
        return this.focused;
    }

    @Override
    public void setFocused(boolean focused) {
        this.focused = focused;
        this.dragging = false;
    }

    @Override
    public boolean isDragging() {
        return this.dragging;
    }

    @Override
    public void setDragging(boolean dragging) {
        this.dragging = dragging;
    }

    public boolean m_5755_(boolean lookForwards) {
        return this.onNavigation(lookForwards ? NavigationDirection.DOWN : NavigationDirection.UP, true);
    }

    @Override
    public boolean onNavigation(NavigationDirection direction, boolean tab) {
        if (this.requiresCursor()) {
            return false;
        }
        if (this.isVisible() && this.isActive()) {
            this.setFocused(!this.isFocused());
            return this.isFocused();
        }
        return false;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (!(this.isActive() && this.isVisible() && this.m_5953_(mouseX, mouseY))) {
            return false;
        }
        return this.onMouseClick(mouseX, mouseY, button);
    }

    protected boolean onMouseClick(double mouseX, double mouseY, int button) {
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        boolean result = this.onMouseRelease(mouseX, mouseY, button);
        if (result) {
            this.dragging = false;
        }
        return result;
    }

    protected boolean onMouseRelease(double mouseX, double mouseY, int button) {
        return false;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (!this.isActive() || !this.isVisible()) {
            return false;
        }
        boolean result = this.onMouseDrag(mouseX, mouseY, button, deltaX, deltaY);
        if (result) {
            this.dragging = true;
            this.lastDrag = Util.m_137550_();
        }
        return result;
    }

    protected boolean onMouseDrag(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (this.isActive() && this.isVisible() && this.m_5953_(mouseX, mouseY)) {
            return this.onMouseScroll(mouseX, mouseY, amount);
        }
        return false;
    }

    protected boolean onMouseScroll(double mouseX, double mouseY, double amount) {
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.isActive() && this.isVisible()) {
            return this.onKeyPress(keyCode, scanCode, modifiers);
        }
        return false;
    }

    protected boolean onKeyPress(int keyCode, int scanCode, int modifiers) {
        return false;
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        if (this.isActive() && this.isVisible()) {
            return this.onKeyRelease(keyCode, scanCode, modifiers);
        }
        return false;
    }

    protected boolean onKeyRelease(int keyCode, int scanCode, int modifiers) {
        return false;
    }

    public boolean m_5534_(char chr, int keyCode) {
        if (this.isActive() && this.isVisible()) {
            return this.onCharTyped(chr, keyCode);
        }
        return false;
    }

    protected boolean onCharTyped(char chr, int keyCode) {
        return false;
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        if (this.isVisible()) {
            boolean bl = this.hovered = mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.getWidth() && mouseY < this.getY() + this.getHeight();
            if (this.dragging && !this.isMouseHovered() && Util.m_137550_() - this.lastDrag > 60L) {
                this.dragging = false;
            }
            this.renderBackground(matrices, mouseX, mouseY, delta);
            this.renderWidget(matrices, mouseX, mouseY, delta);
            this.wasHovered = this.isMouseHovered();
        } else {
            this.wasHovered = false;
            this.hovered = false;
        }
    }

    protected abstract void renderWidget(PoseStack var1, int var2, int var3, float var4);

    protected void renderBackground(PoseStack matrices, int mouseX, int mouseY, float delta) {
    }

    public void playDownSound() {
        this.client.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
    }

    public void m_142291_(NarrationElementOutput builder) {
        Component narrationMessage = this.getNarrationMessage();
        if (narrationMessage != null) {
            builder.m_169146_(NarratedElementType.TITLE, narrationMessage);
        }
    }

    @Nullable
    protected Component getNarrationMessage() {
        return null;
    }
}

