/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.spruceui.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.lambdaurora.spruceui.Position;
import dev.lambdaurora.spruceui.Tooltip;
import dev.lambdaurora.spruceui.Tooltipable;
import dev.lambdaurora.spruceui.widget.AbstractSpruceWidget;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.jetbrains.annotations.Nullable;

public class SpruceSeparatorWidget
extends AbstractSpruceWidget
implements Tooltipable {
    private final Minecraft client = Minecraft.m_91087_();
    private Component title;
    private Component tooltip;
    private int tooltipTicks;
    private long lastTick;

    public SpruceSeparatorWidget(Position position, int width, @Nullable Component title) {
        super(position);
        this.width = width;
        this.height = 9;
        this.title = title;
    }

    @Deprecated
    public SpruceSeparatorWidget(@Nullable Component title, int x, int y, int width) {
        this(Position.of(x, y), width, title);
    }

    public Optional<Component> getTitle() {
        return Optional.ofNullable(this.title);
    }

    public void setTitle(@Nullable Component title) {
        this.title = title;
    }

    @Override
    public Optional<Component> getTooltip() {
        return Optional.ofNullable(this.tooltip);
    }

    @Override
    public void setTooltip(@Nullable Component tooltip) {
        this.tooltip = tooltip;
    }

    @Override
    public boolean requiresCursor() {
        return this.tooltip == null;
    }

    @Override
    protected void renderWidget(PoseStack matrices, int mouseX, int mouseY, float delta) {
        if (this.title != null) {
            int titleWidth = this.client.f_91062_.m_92852_((FormattedText)this.title);
            int titleX = this.getX() + (this.getWidth() / 2 - titleWidth / 2);
            if (this.width > titleWidth) {
                SpruceSeparatorWidget.m_93172_((PoseStack)matrices, (int)this.getX(), (int)(this.getY() + 4), (int)(titleX - 5), (int)(this.getY() + 6), (int)-2039584);
                SpruceSeparatorWidget.m_93172_((PoseStack)matrices, (int)(titleX + titleWidth + 5), (int)(this.getY() + 4), (int)(this.getX() + this.getWidth()), (int)(this.getY() + 6), (int)-2039584);
            }
            SpruceSeparatorWidget.m_93243_((PoseStack)matrices, (Font)this.client.f_91062_, (Component)this.title, (int)titleX, (int)this.getY(), (int)-1);
        } else {
            SpruceSeparatorWidget.m_93172_((PoseStack)matrices, (int)this.getX(), (int)(this.getY() + 4), (int)(this.getX() + this.getWidth()), (int)(this.getY() + 6), (int)-2039584);
        }
        Tooltip.queueFor(this, mouseX, mouseY, this.tooltipTicks, i -> {
            this.tooltipTicks = i;
        }, this.lastTick, i -> {
            this.lastTick = i;
        });
    }

    @Override
    protected Component getNarrationMessage() {
        return this.getTitle().map(Component::getString).filter(title -> !title.isEmpty()).map(title -> Component.m_237110_((String)"spruceui.narrator.separator", (Object[])new Object[]{title})).orElse(null);
    }
}

