/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.spruceui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.lambdaurora.spruceui.Position;
import dev.lambdaurora.spruceui.widget.SpruceButtonWidget;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class SpruceTexturedButtonWidget
extends SpruceButtonWidget {
    private final ResourceLocation texture;
    private final int u;
    private final int v;
    private final int hoveredVOffset;
    private final int textureWidth;
    private final int textureHeight;
    private final boolean showMessage;

    public SpruceTexturedButtonWidget(Position position, int width, int height, Component message, SpruceButtonWidget.PressAction action, int u, int v, int hoveredVOffset, ResourceLocation texture) {
        this(position, width, height, message, false, action, u, v, hoveredVOffset, texture);
    }

    public SpruceTexturedButtonWidget(Position position, int width, int height, Component message, boolean showMessage, SpruceButtonWidget.PressAction action, int u, int v, int hoveredVOffset, ResourceLocation texture) {
        this(position, width, height, message, showMessage, action, u, v, hoveredVOffset, texture, 256, 256);
    }

    public SpruceTexturedButtonWidget(Position position, int width, int height, Component message, SpruceButtonWidget.PressAction action, int u, int v, int hoveredVOffset, ResourceLocation texture, int textureWidth, int textureHeight) {
        this(position, width, height, message, false, action, u, v, hoveredVOffset, texture, textureWidth, textureHeight);
    }

    public SpruceTexturedButtonWidget(Position position, int width, int height, Component message, boolean showMessage, SpruceButtonWidget.PressAction action, int u, int v, int hoveredVOffset, ResourceLocation texture, int textureWidth, int textureHeight) {
        super(position, width, height, message, action);
        this.texture = texture;
        this.u = u;
        this.v = v;
        this.hoveredVOffset = hoveredVOffset;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.showMessage = showMessage;
    }

    @Override
    protected void renderButton(PoseStack matrices, int mouseX, int mouseY, float delta) {
        if (this.showMessage) {
            super.renderButton(matrices, mouseX, mouseY, delta);
        }
    }

    @Override
    protected void renderBackground(PoseStack matrices, int mouseX, int mouseY, float delta) {
        int v = this.v;
        if (this.isFocusedOrHovered()) {
            v += this.hoveredVOffset;
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)this.getAlpha());
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.texture);
        RenderSystem.m_69482_();
        SpruceTexturedButtonWidget.m_93133_((PoseStack)matrices, (int)this.getX(), (int)this.getY(), (float)this.u, (float)v, (int)this.getWidth(), (int)this.getHeight(), (int)this.textureWidth, (int)this.textureHeight);
    }

    @Override
    public String toString() {
        return "SpruceTexturedButtonWidget{position=" + String.valueOf(this.getPosition()) + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ", visible=" + this.isVisible() + ", active=" + this.isActive() + ", message=" + String.valueOf(this.getMessage()) + ", focused=" + this.isFocused() + ", hovered=" + this.isMouseHovered() + ", wasHovered=" + this.wasHovered + ", dragging=" + this.dragging + ", lastDrag=" + this.lastDrag + ", alpha=" + this.getAlpha() + ", texture=" + String.valueOf(this.texture) + ", u=" + this.u + ", v=" + this.v + ", hoveredVOffset=" + this.hoveredVOffset + ", textureWidth=" + this.textureWidth + ", textureHeight=" + this.textureHeight + ", showMessage=" + this.showMessage + "}";
    }
}

