/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.spruceui.widget.text;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.lambdaurora.spruceui.Position;
import dev.lambdaurora.spruceui.background.Background;
import dev.lambdaurora.spruceui.background.SimpleColorBackground;
import dev.lambdaurora.spruceui.border.Border;
import dev.lambdaurora.spruceui.border.SimpleBorder;
import dev.lambdaurora.spruceui.widget.AbstractSpruceWidget;
import dev.lambdaurora.spruceui.widget.WithBackground;
import dev.lambdaurora.spruceui.widget.WithBorder;
import net.minecraft.network.chat.Component;

public abstract class AbstractSpruceTextInputWidget
extends AbstractSpruceWidget
implements WithBackground,
WithBorder {
    private final Component title;
    private Background background = new SimpleColorBackground(-16777216);
    private Border border = new SimpleBorder(1, -6250336, -1);
    private int editableColor = -2039584;
    private int uneditableColor = -9408400;

    public AbstractSpruceTextInputWidget(Position position, int width, int height, Component title) {
        super(position);
        this.width = width;
        this.height = height;
        this.title = title;
    }

    public abstract String getText();

    public abstract void setText(String var1);

    public Component getTitle() {
        return this.title;
    }

    public int getEditableColor() {
        return this.editableColor;
    }

    public void setEditableColor(int editableColor) {
        this.editableColor = editableColor;
    }

    public int getUneditableColor() {
        return this.uneditableColor;
    }

    public void setUneditableColor(int uneditableColor) {
        this.uneditableColor = uneditableColor;
    }

    public int getTextColor() {
        return this.isActive() ? this.getEditableColor() : this.getUneditableColor();
    }

    public abstract void setCursorToStart();

    public abstract void setCursorToEnd();

    @Override
    public Background getBackground() {
        return this.background;
    }

    @Override
    public void setBackground(Background background) {
        this.background = background;
    }

    @Override
    public Border getBorder() {
        return this.border;
    }

    @Override
    public void setBorder(Border border) {
        this.border = border;
    }

    public int getInnerWidth() {
        return this.getWidth() - 6 - this.getBorder().getThickness() * 2;
    }

    public int getInnerHeight() {
        return this.getHeight() - 6 - this.getBorder().getThickness() * 2;
    }

    protected abstract void sanitize();

    public boolean isEditorActive() {
        return this.isActive() && this.isFocused();
    }

    @Override
    protected void renderWidget(PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.getBorder().render(matrices, this, mouseX, mouseY, delta);
    }

    @Override
    protected void renderBackground(PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.getBackground().render(matrices, this, 0, mouseX, mouseY, delta);
    }

    @Override
    protected Component getNarrationMessage() {
        return Component.m_237110_((String)"gui.narrate.editBox", (Object[])new Object[]{this.getTitle(), this.getText()});
    }
}

