/*
 * Decompiled with CFR 0.152.
 */
package top.leonx.irisflw.transformer;

import com.jozufozu.flywheel.api.vertex.VertexType;
import com.jozufozu.flywheel.core.compile.CompileUtil;
import com.jozufozu.flywheel.core.compile.InstancingTemplateData;
import com.jozufozu.flywheel.core.compile.OneShotTemplateData;
import com.jozufozu.flywheel.core.compile.Template;
import com.jozufozu.flywheel.core.compile.VertexData;
import com.jozufozu.flywheel.core.shader.StateSnapshot;
import com.jozufozu.flywheel.core.source.FileIndex;
import com.jozufozu.flywheel.core.source.FileIndexImpl;
import com.jozufozu.flywheel.core.source.FileResolution;
import com.jozufozu.flywheel.core.source.SourceFile;
import com.jozufozu.flywheel.core.source.parse.ShaderStruct;
import com.jozufozu.flywheel.core.source.parse.StructField;

public abstract class ShaderPatcherBase {
    protected final FileResolution header;
    protected final Template<? extends VertexData> template;

    public ShaderPatcherBase(Template<? extends VertexData> template, FileResolution header) {
        this.header = header;
        this.template = template;
    }

    public abstract String patch(String var1, Context var2);

    public void generateCreateVertex(VertexData template, StringBuilder createVertexBuilder) {
        if (template instanceof InstancingTemplateData) {
            InstancingTemplateData instancingTemplate = (InstancingTemplateData)template;
            createVertexBuilder.append(String.format("     v = FLWCreateVertex();\n     %s i;\n     %s\n     vertex(v, i);\n", instancingTemplate.instanceName, InstancingTemplateData.assignFields((ShaderStruct)instancingTemplate.instance, (String)"i.", (String)"a_i_")));
        } else if (template instanceof OneShotTemplateData) {
            createVertexBuilder.append("     v = FLWCreateVertex();\n     vertex(v);\n");
        }
    }

    public void generateInputAttribute(VertexData template, VertexType vertexType, StringBuilder builder) {
        if (template instanceof InstancingTemplateData) {
            InstancingTemplateData instancingTemplate = (InstancingTemplateData)template;
            int attributeBinding = vertexType.getLayout().getAttributeCount();
            for (StructField field : instancingTemplate.instance.getFields()) {
                builder.append("layout(location = ").append(attributeBinding).append(") in").append(' ').append((CharSequence)field.type).append(' ').append("a_i_").append((CharSequence)field.name).append(";\n");
                attributeBinding += CompileUtil.getAttributeCount((CharSequence)field.type);
            }
        }
    }

    protected void genCommonSource(StringBuilder structBuilder, Context key, VertexData appliedTemplate) {
        structBuilder.append("#define VERTEX_SHADER\n");
        FileIndexImpl index = new FileIndexImpl();
        this.header.getFile().generateFinalSource((FileIndex)index, structBuilder);
        key.file.generateFinalSource((FileIndex)index, structBuilder);
        this.generateInputAttribute(appliedTemplate, key.vertexType, structBuilder);
    }

    protected void genHeadSource(StringBuilder headerBuilder, Context key) {
        headerBuilder.append("struct Vertex {\n\tvec3 pos;\n\tvec4 color;\n\tvec2 texCoords;\n\tvec2 light;\n\tvec3 normal;\n};\n\nVertex v; //define outside of main() so all function can use it.\nvec4 _flw_patched_vertex_pos;\n");
        headerBuilder.append(key.vertexType.getShaderHeader());
    }

    public record Context(SourceFile file, StateSnapshot ctx, VertexType vertexType) {
        public SourceFile getFile() {
            return this.file;
        }

        public StateSnapshot getCtx() {
            return this.ctx;
        }

        public VertexType getVertexType() {
            return this.vertexType;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Context that = (Context)o;
            return this.file == that.file && this.vertexType == that.vertexType && this.ctx.equals((Object)that.ctx);
        }
    }
}

