/*
 * Decompiled with CFR 0.152.
 */
package top.leonx.irisflw.vertex;

import com.google.common.collect.ImmutableList;
import com.jozufozu.flywheel.core.vertex.AbstractVertexList;
import com.jozufozu.flywheel.util.RenderMath;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.nio.ByteBuffer;
import net.coderbot.iris.vertices.IrisVertexFormats;
import org.lwjgl.system.MemoryUtil;
import top.leonx.irisflw.vertex.IrisBlockVertexReader;

public class IrisBlockVertexReaderImpl
extends AbstractVertexList
implements IrisBlockVertexReader {
    private final IntList offsets = new IntArrayList();
    private final int vertexSize;

    public IrisBlockVertexReaderImpl(ByteBuffer copyFrom, int vertexCount) {
        super(copyFrom, vertexCount);
        ImmutableList elements = IrisVertexFormats.TERRAIN.m_86023_();
        int offset = 0;
        for (int i = 0; i < elements.size(); ++i) {
            if (elements.get(i) != DefaultVertexFormat.f_85810_) {
                this.offsets.add(offset);
            }
            offset += ((VertexFormatElement)elements.get(i)).m_86050_();
        }
        this.vertexSize = IrisVertexFormats.TERRAIN.m_86020_();
    }

    private long ptr(long index) {
        return this.base + index * (long)this.vertexSize;
    }

    public float getX(int index) {
        return MemoryUtil.memGetFloat((long)(this.ptr(index) + (long)this.offsets.getInt(0)));
    }

    public float getY(int index) {
        return MemoryUtil.memGetFloat((long)(this.ptr(index) + (long)this.offsets.getInt(0) + 4L));
    }

    public float getZ(int index) {
        return MemoryUtil.memGetFloat((long)(this.ptr(index) + (long)this.offsets.getInt(0) + 8L));
    }

    public byte getR(int index) {
        return MemoryUtil.memGetByte((long)(this.ptr(index) + (long)this.offsets.getInt(1)));
    }

    public byte getG(int index) {
        return MemoryUtil.memGetByte((long)(this.ptr(index) + (long)this.offsets.getInt(1) + 1L));
    }

    public byte getB(int index) {
        return MemoryUtil.memGetByte((long)(this.ptr(index) + (long)this.offsets.getInt(1) + 2L));
    }

    public byte getA(int index) {
        return MemoryUtil.memGetByte((long)(this.ptr(index) + (long)this.offsets.getInt(1) + 3L));
    }

    public float getU(int index) {
        return MemoryUtil.memGetFloat((long)(this.ptr(index) + (long)this.offsets.getInt(2)));
    }

    public float getV(int index) {
        return MemoryUtil.memGetFloat((long)(this.ptr(index) + (long)this.offsets.getInt(2) + 4L));
    }

    public int getLight(int index) {
        return MemoryUtil.memGetInt((long)(this.ptr(index) + (long)this.offsets.getInt(3)));
    }

    public float getNX(int index) {
        return RenderMath.f((byte)MemoryUtil.memGetByte((long)(this.ptr(index) + (long)this.offsets.getInt(4))));
    }

    public float getNY(int index) {
        return RenderMath.f((byte)MemoryUtil.memGetByte((long)(this.ptr(index) + (long)this.offsets.getInt(4) + 1L)));
    }

    public float getNZ(int index) {
        return RenderMath.f((byte)MemoryUtil.memGetByte((long)(this.ptr(index) + (long)this.offsets.getInt(4) + 2L)));
    }

    @Override
    public short getEntityX(int index) {
        return MemoryUtil.memGetShort((long)(this.ptr(index) + (long)this.offsets.getInt(5)));
    }

    @Override
    public short getEntityY(int index) {
        return MemoryUtil.memGetShort((long)(this.ptr(index) + (long)this.offsets.getInt(5) + 2L));
    }

    @Override
    public float getMidTexU(int index) {
        return MemoryUtil.memGetFloat((long)(this.ptr(index) + (long)this.offsets.getInt(6)));
    }

    @Override
    public float getMidTexV(int index) {
        return MemoryUtil.memGetFloat((long)(this.ptr(index) + (long)this.offsets.getInt(6) + 4L));
    }

    @Override
    public int getTangent(int index) {
        return MemoryUtil.memGetInt((long)(this.ptr(index) + (long)this.offsets.getInt(7)));
    }

    @Override
    public int getMidBlock(int index) {
        return MemoryUtil.memGetInt((long)(this.ptr(index) + (long)this.offsets.getInt(8)));
    }

    @Override
    public int copyTo(long dst, int index) {
        MemoryUtil.memCopy((long)this.ptr(index), (long)dst, (long)this.vertexSize);
        return this.vertexSize;
    }
}

