/*
 * Decompiled with CFR 0.152.
 */
package top.leonx.irisflw.vertex.block;

import com.jozufozu.flywheel.api.vertex.VertexList;
import com.jozufozu.flywheel.core.vertex.BlockVertex;
import com.jozufozu.flywheel.core.vertex.BlockWriterUnsafe;
import com.jozufozu.flywheel.util.RenderMath;
import java.nio.ByteBuffer;
import net.coderbot.iris.vertices.NormI8;
import org.lwjgl.system.MemoryUtil;
import top.leonx.irisflw.vertex.IrisBlockVertexReader;
import top.leonx.irisflw.vertex.block.ExtendedBlockVertex;

public class ExtendedBlockWriterUnsafe
extends BlockWriterUnsafe {
    public ExtendedBlockWriterUnsafe(BlockVertex type, ByteBuffer buffer) {
        super(type, buffer);
    }

    public void writeVertex(VertexList list, int i) {
        float x = list.getX(i);
        float y = list.getY(i);
        float z = list.getZ(i);
        float xN = list.getNX(i);
        float yN = list.getNY(i);
        float zN = list.getNZ(i);
        float u = list.getU(i);
        float v = list.getV(i);
        byte r = list.getR(i);
        byte g = list.getG(i);
        byte b = list.getB(i);
        byte a = list.getA(i);
        int light = list.getLight(i);
        MemoryUtil.memPutFloat((long)this.ptr, (float)x);
        MemoryUtil.memPutFloat((long)(this.ptr + 4L), (float)y);
        MemoryUtil.memPutFloat((long)(this.ptr + 8L), (float)z);
        MemoryUtil.memPutByte((long)(this.ptr + 12L), (byte)r);
        MemoryUtil.memPutByte((long)(this.ptr + 13L), (byte)g);
        MemoryUtil.memPutByte((long)(this.ptr + 14L), (byte)b);
        MemoryUtil.memPutByte((long)(this.ptr + 15L), (byte)a);
        MemoryUtil.memPutFloat((long)(this.ptr + 16L), (float)u);
        MemoryUtil.memPutFloat((long)(this.ptr + 20L), (float)v);
        MemoryUtil.memPutInt((long)(this.ptr + 24L), (int)(light << 8));
        MemoryUtil.memPutByte((long)(this.ptr + 28L), (byte)RenderMath.nb((float)xN));
        MemoryUtil.memPutByte((long)(this.ptr + 29L), (byte)RenderMath.nb((float)yN));
        MemoryUtil.memPutByte((long)(this.ptr + 30L), (byte)RenderMath.nb((float)zN));
        if (list instanceof IrisBlockVertexReader) {
            IrisBlockVertexReader irisVertexList = (IrisBlockVertexReader)list;
            float midU = irisVertexList.getMidTexU(i);
            float midV = irisVertexList.getMidTexV(i);
            int tangent = irisVertexList.getTangent(i);
            tangent = this.repackTangent(tangent);
            int midBlock = irisVertexList.getMidBlock(i);
            midBlock = this.repackMidBlock(midBlock);
            short entityX = irisVertexList.getEntityX(i);
            short entityY = irisVertexList.getEntityY(i);
            MemoryUtil.memPutFloat((long)(this.ptr + 32L), (float)midU);
            MemoryUtil.memPutFloat((long)(this.ptr + 36L), (float)midV);
            MemoryUtil.memPutFloat((long)(this.ptr + 40L), (float)Float.intBitsToFloat(tangent));
            MemoryUtil.memPutFloat((long)(this.ptr + 44L), (float)Float.intBitsToFloat(midBlock));
            MemoryUtil.memPutShort((long)(this.ptr + 48L), (short)entityX);
            MemoryUtil.memPutShort((long)(this.ptr + 50L), (short)entityY);
        } else {
            MemoryUtil.memPutLong((long)(this.ptr + 32L), (long)0L);
            MemoryUtil.memPutLong((long)(this.ptr + 40L), (long)0L);
            MemoryUtil.memPutInt((long)(this.ptr + 48L), (int)0);
        }
        this.ptr += (long)ExtendedBlockVertex.EXTEND_FORMAT.getStride();
        this.advance();
    }

    private int repackTangent(int packedTangent) {
        float x = NormI8.unpackX((int)packedTangent) + 1.0f;
        float y = NormI8.unpackY((int)packedTangent) + 1.0f;
        float z = NormI8.unpackZ((int)packedTangent) + 1.0f;
        float w = NormI8.unpackW((int)packedTangent) + 1.0f;
        return NormI8.pack((float)x, (float)y, (float)z, (float)w);
    }

    private int repackMidBlock(int midBlock) {
        float x = (float)(midBlock & 0xFF) * 0.015625f + 2.0f;
        float y = (float)(midBlock >> 8 & 0xFF) * 0.015625f + 2.0f;
        float z = (float)(midBlock >> 16 & 0xFF) * 0.015625f + 2.0f;
        int emission = midBlock >> 24 & 0xFF;
        return (int)(x * 64.0f) & 0xFF | ((int)(y * 64.0f) & 0xFF) << 8 | ((int)(z * 64.0f) & 0xFF) << 16 | emission << 24;
    }
}

