/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.packet.parties;

import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.client.parties.party.IClientPartyStorage;
import xaero.pac.common.server.lazypacket.LazyPacket;

public class ClientboundPartyNamePacket
extends LazyPacket<ClientboundPartyNamePacket> {
    public static final LazyPacket.Encoder<ClientboundPartyNamePacket> ENCODER = new LazyPacket.Encoder();
    public static final Decoder DECODER = new Decoder();
    private final String name;

    public ClientboundPartyNamePacket(String name) {
        this.name = name;
    }

    @Override
    protected void writeOnPrepare(FriendlyByteBuf u) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("n", this.name == null ? "" : this.name);
        u.m_130079_(tag);
    }

    @Override
    protected Function<FriendlyByteBuf, ClientboundPartyNamePacket> getDecoder() {
        return DECODER;
    }

    public static class Decoder
    implements Function<FriendlyByteBuf, ClientboundPartyNamePacket> {
        @Override
        public ClientboundPartyNamePacket apply(FriendlyByteBuf input) {
            try {
                if (input.readableBytes() > 16384) {
                    return null;
                }
                CompoundTag tag = input.m_130261_();
                if (tag == null) {
                    return null;
                }
                String name = tag.m_128461_("n");
                if (name.length() > 512) {
                    return null;
                }
                return new ClientboundPartyNamePacket(name);
            }
            catch (Throwable t) {
                OpenPartiesAndClaims.LOGGER.error("invalid packet ", t);
                return null;
            }
        }
    }

    public static class ClientHandler
    extends LazyPacket.Handler<ClientboundPartyNamePacket> {
        @Override
        public void handle(ClientboundPartyNamePacket t) {
            ((IClientPartyStorage)OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientPartyStorage()).setPartyName(t.name);
        }
    }
}

