/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.io;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Supplier;
import xaero.pac.common.server.io.exception.IOThreadWorkerException;

public class IOThreadWorker
implements Runnable {
    private final ConcurrentLinkedQueue<Runnable> taskQueue = new ConcurrentLinkedQueue();
    private boolean running = true;
    private Thread thread;
    private Throwable crashThrowable;

    public void begin() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        IOThreadWorker iOThreadWorker = this;
        synchronized (iOThreadWorker) {
            while (true) {
                Runnable task;
                if (!this.running) {
                    if (this.taskQueue.isEmpty()) return;
                }
                while ((task = this.taskQueue.poll()) != null) {
                    try {
                        task.run();
                    }
                    catch (Throwable t) {
                        if (this.crashThrowable != null) continue;
                        this.crashThrowable = t;
                    }
                }
                if (!this.running) continue;
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.running = false;
        IOThreadWorker iOThreadWorker = this;
        synchronized (iOThreadWorker) {
        }
        if (!this.taskQueue.isEmpty()) {
            throw new IllegalStateException();
        }
    }

    private void enqueueInternal(Runnable task) {
        if (!this.running) {
            throw new IllegalStateException();
        }
        this.taskQueue.add(task);
        this.thread.interrupt();
    }

    public void enqueue(Runnable task) {
        this.enqueueInternal(() -> {
            if (this.crashThrowable != null) {
                return;
            }
            task.run();
        });
    }

    public <T> CompletableFuture<T> getFuture(Supplier<T> task) {
        CompletableFuture future = new CompletableFuture();
        this.enqueue(() -> future.complete(task.get()));
        return future;
    }

    public <T> T get(Supplier<T> task) {
        CompletableFuture future = new CompletableFuture();
        this.enqueueInternal(() -> {
            try {
                if (this.crashThrowable != null) {
                    throw new IOThreadWorkerException();
                }
                future.complete(task.get());
            }
            catch (Throwable t) {
                future.completeExceptionally(t);
            }
        });
        return future.join();
    }

    public void checkCrashes() throws Throwable {
        if (this.crashThrowable != null) {
            Throwable toThrow = this.crashThrowable;
            this.crashThrowable = null;
            if (toThrow instanceof RuntimeException) {
                throw toThrow;
            }
            throw new RuntimeException(toThrow);
        }
    }
}

