/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.packet;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class PacketConsumerForge<P>
implements BiConsumer<P, Supplier<NetworkEvent.Context>> {
    private final BiConsumer<P, ServerPlayer> serverHandler;
    private final Consumer<P> clientHandler;

    public PacketConsumerForge(BiConsumer<P, ServerPlayer> serverHandler, Consumer<P> clientHandler) {
        this.serverHandler = serverHandler;
        this.clientHandler = clientHandler;
    }

    @Override
    public void accept(P msg, Supplier<NetworkEvent.Context> contextSupplier) {
        if (msg == null) {
            contextSupplier.get().setPacketHandled(true);
            return;
        }
        NetworkDirection networkDirection = contextSupplier.get().getDirection();
        if (this.clientHandler != null && networkDirection == NetworkDirection.PLAY_TO_CLIENT) {
            contextSupplier.get().enqueueWork(() -> this.clientHandler.accept(msg));
        } else if (this.serverHandler != null && networkDirection == NetworkDirection.PLAY_TO_SERVER) {
            ServerPlayer sender = contextSupplier.get().getSender();
            contextSupplier.get().enqueueWork(() -> this.serverHandler.accept(msg, sender));
        }
        contextSupplier.get().setPacketHandled(true);
    }
}

