/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.parties.system;

import java.util.Map;
import java.util.UUID;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.misc.MapFactory;
import xaero.pac.common.server.parties.system.IPlayerPartySystemManager;
import xaero.pac.common.server.parties.system.api.IPlayerPartySystemAPI;

public final class PlayerPartySystemManager
implements IPlayerPartySystemManager {
    private final Map<String, IPlayerPartySystemAPI<?>> systems;
    private final Map<IPlayerPartySystemAPI<?>, String> systemNames;
    private IPlayerPartySystemAPI<?> primarySystem;
    private boolean registeringAddons;

    private PlayerPartySystemManager(Map<String, IPlayerPartySystemAPI<?>> systems, Map<IPlayerPartySystemAPI<?>, String> systemNames) {
        this.systems = systems;
        this.systemNames = systemNames;
    }

    @Override
    public void preRegister() {
        this.registeringAddons = true;
    }

    @Override
    public void register(String name, IPlayerPartySystemAPI<?> system) {
        if (!this.registeringAddons) {
            throw new IllegalStateException("You must register OPAC addons during the OPACServerAddonRegister event! (OPACServerAddonRegisterEvent on Forge)");
        }
        if (this.systems.containsKey(name)) {
            throw new IllegalArgumentException("This party system name is already registered!");
        }
        this.systems.put(name, system);
        this.systemNames.put(system, name);
        OpenPartiesAndClaims.LOGGER.info("Registered party system for OPAC: {}", (Object)name);
    }

    @Override
    public void postRegister() {
        this.registeringAddons = false;
    }

    @Override
    public void updatePrimarySystem(String configuredPrimarySystem) {
        this.primarySystem = this.systems.get(configuredPrimarySystem);
        if (this.primarySystem == null) {
            OpenPartiesAndClaims.LOGGER.warn("The configured primary party system \"{}\" isn't registered!", (Object)configuredPrimarySystem);
            this.primarySystem = this.systems.get("default");
        }
        OpenPartiesAndClaims.LOGGER.info("Configured OPAC to use the following party system as primary: {}", (Object)this.systemNames.get(this.primarySystem));
    }

    @Override
    public IPlayerPartySystemAPI<?> getPrimarySystem() {
        return this.primarySystem;
    }

    @Override
    public Iterable<IPlayerPartySystemAPI<?>> getRegisteredSystems() {
        return this.systems.values();
    }

    @Override
    public boolean isInAParty(UUID playerId) {
        Iterable<IPlayerPartySystemAPI<?>> allSystems = this.getRegisteredSystems();
        for (IPlayerPartySystemAPI<?> partySystem : allSystems) {
            if (partySystem.getPartyByMember(playerId) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean areInSameParty(UUID playerId, UUID otherPlayerId) {
        Iterable<IPlayerPartySystemAPI<?>> allSystems = this.getRegisteredSystems();
        for (IPlayerPartySystemAPI<?> partySystem : allSystems) {
            Object playerParty = partySystem.getPartyByMember(playerId);
            if (playerParty == null || playerParty != partySystem.getPartyByMember(otherPlayerId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isPlayerAllying(UUID playerId, UUID potentialAllyPlayerId) {
        Iterable<IPlayerPartySystemAPI<?>> allSystems = this.getRegisteredSystems();
        for (IPlayerPartySystemAPI<?> partySystem : allSystems) {
            if (!partySystem.isPlayerAllying(playerId, potentialAllyPlayerId)) continue;
            return true;
        }
        return false;
    }

    public static final class Builder {
        private final MapFactory mapFactory;

        private Builder(MapFactory mapFactory) {
            this.mapFactory = mapFactory;
        }

        public Builder setDefault() {
            return this;
        }

        public PlayerPartySystemManager build() {
            if (this.mapFactory == null) {
                throw new IllegalStateException();
            }
            return new PlayerPartySystemManager(this.mapFactory.get(), this.mapFactory.get());
        }

        public static Builder begin(MapFactory mapFactory) {
            return new Builder(mapFactory).setDefault();
        }
    }
}

