/*
 * Decompiled with CFR 0.152.
 */
package com.decursioteam.pickableorbs.codec;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;

public class ExtraOptions {
    public static final ExtraOptions DEFAULT = new ExtraOptions("", false, true, false, 20);
    public static final Codec<ExtraOptions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("pickup-message").orElse((Object)"").forGetter(ExtraOptions::getPickupMessage), (App)Codec.BOOL.fieldOf("animation").orElse((Object)false).forGetter(ExtraOptions::getAnimation), (App)Codec.BOOL.fieldOf("sound").orElse((Object)false).forGetter(ExtraOptions::getSound), (App)Codec.BOOL.fieldOf("follow-player").orElse((Object)false).forGetter(ExtraOptions::getFollowPlayer), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("pickup-delay").orElse((Object)20).forGetter(ExtraOptions::getPickupDelay)).apply((Applicative)instance, ExtraOptions::new));
    protected boolean sound;
    protected String pickupMessage;
    protected boolean animation;
    protected boolean followPlayer;
    protected int pickupDelay;

    private ExtraOptions(String pickupMessage, boolean animation, boolean sound, boolean followPlayer, int pickupDelay) {
        this.sound = sound;
        this.pickupMessage = pickupMessage;
        this.animation = animation;
        this.followPlayer = followPlayer;
        this.pickupDelay = pickupDelay;
    }

    public String getPickupMessage() {
        return this.pickupMessage;
    }

    public boolean getAnimation() {
        return this.animation;
    }

    public boolean getSound() {
        return this.sound;
    }

    public boolean getFollowPlayer() {
        return this.followPlayer;
    }

    public int getPickupDelay() {
        return this.pickupDelay;
    }

    public ExtraOptions toImmutable() {
        return this;
    }

    public static class Mutable
    extends ExtraOptions {
        public Mutable(String pickupMessage, boolean animation, boolean sound, boolean followPlayer, int pickupDelay) {
            super(pickupMessage, animation, sound, followPlayer, pickupDelay);
        }

        public Mutable setAnimation(boolean animation) {
            this.animation = animation;
            return this;
        }

        public Mutable setSound(boolean sound) {
            this.sound = sound;
            return this;
        }

        public Mutable setFollowPlayer(boolean followPlayer) {
            this.followPlayer = followPlayer;
            return this;
        }

        @Override
        public ExtraOptions toImmutable() {
            return new ExtraOptions(this.pickupMessage, this.animation, this.sound, this.followPlayer, this.pickupDelay);
        }
    }
}

