/*
 * Decompiled with CFR 0.152.
 */
package com.decursioteam.pickableorbs.codec;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapDecoder;
import com.mojang.serialization.MapEncoder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.ForgeRegistries;

public class OrbData {
    public static final OrbData DEFAULT = new OrbData("error");
    protected double blockDropChance;
    protected double entityDropChance;
    protected int effectMultiplier;
    protected int effectDuration;
    protected ResourceLocation texture;
    protected List<ResourceLocation> blockSet;
    protected List<ResourceLocation> entitySet;
    protected String color;
    protected String name;
    protected ResourceLocation type;
    protected String blockListType;
    protected String entityListType;

    public static Codec<OrbData> codec(String name) {
        return RecordCodecBuilder.create(instance -> instance.group((App)MapCodec.of((MapEncoder)Encoder.empty(), (MapDecoder)Decoder.unit(() -> name)).forGetter(OrbData::getName), (App)ResourceLocation.f_135803_.fieldOf("type").orElse((Object)ForgeRegistries.MOB_EFFECTS.getKey((Object)MobEffects.f_19601_)).forGetter(OrbData::getType), (App)Codec.intRange((int)0, (int)100).fieldOf("effectMultiplier").orElse((Object)1).forGetter(OrbData::getEffectMultiplier), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("effectDuration").orElse((Object)100).forGetter(OrbData::getEffectDuration), (App)Codec.STRING.fieldOf("color").forGetter(OrbData::getColor), (App)ResourceLocation.f_135803_.fieldOf("texture").orElse((Object)new ResourceLocation("pickableorbs:textures/entity/plain_orb.png")).forGetter(OrbData::getTexture), (App)ResourceLocation.f_135803_.listOf().fieldOf("blockList").orElse((Object)ImmutableList.of((Object)Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)Blocks.f_50085_)))).forGetter(OrbData::getBlockSet), (App)Codec.STRING.fieldOf("blockListType").orElse((Object)"whitelist").forGetter(OrbData::getBlockListType), (App)Codec.doubleRange((double)0.0, (double)100.0).fieldOf("blockDropChance").orElse((Object)0.0).forGetter(OrbData::getBlockDropChance), (App)ResourceLocation.f_135803_.listOf().fieldOf("entityList").orElse((Object)ImmutableList.of((Object)Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey((Object)EntityType.f_20517_)))).forGetter(OrbData::getEntitySet), (App)Codec.STRING.fieldOf("entityListType").orElse((Object)"whitelist").forGetter(OrbData::getEntityListType), (App)Codec.doubleRange((double)0.0, (double)100.0).fieldOf("entityDropChance").orElse((Object)0.0).forGetter(OrbData::getEntityDropChance)).apply((Applicative)instance, OrbData::new));
    }

    private OrbData(String name, ResourceLocation type, int effectMultiplier, int effectDuration, String color, ResourceLocation texture, List<ResourceLocation> blockSet, String blockListType, double blockDropChance, List<ResourceLocation> entitySet, String entityListType, double entityDropChance) {
        this.name = name;
        this.effectDuration = effectDuration;
        this.effectMultiplier = effectMultiplier;
        this.type = type;
        this.blockDropChance = blockDropChance;
        this.entityDropChance = entityDropChance;
        this.blockListType = blockListType;
        this.entityListType = entityListType;
        this.color = color;
        this.texture = texture;
        this.blockSet = blockSet;
        this.entitySet = entitySet;
    }

    private OrbData(String name) {
        this.name = name;
        this.type = ForgeRegistries.MOB_EFFECTS.getKey((Object)MobEffects.f_19601_);
        this.effectMultiplier = 1;
        this.effectDuration = 100;
        this.blockDropChance = 1.0;
        this.entityDropChance = 50.0;
        this.blockListType = "whitelist";
        this.entityListType = "blacklist";
        this.texture = new ResourceLocation("pickableorbs:textures/entity/plain_orb.png");
        this.color = "#FF4500";
        this.blockSet = new ArrayList<ResourceLocation>();
        this.entitySet = new ArrayList<ResourceLocation>();
    }

    public int getEffectMultiplier() {
        return this.effectMultiplier;
    }

    public int getEffectDuration() {
        return this.effectDuration;
    }

    public List<ResourceLocation> getBlockSet() {
        return this.blockSet;
    }

    public List<ResourceLocation> getEntitySet() {
        return this.entitySet;
    }

    public double getBlockDropChance() {
        return this.blockDropChance;
    }

    public double getEntityDropChance() {
        return this.entityDropChance;
    }

    public String getColor() {
        return this.color;
    }

    public String getBlockListType() {
        return this.blockListType;
    }

    public String getEntityListType() {
        return this.entityListType;
    }

    public ResourceLocation getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public OrbData toImmutable() {
        return this;
    }

    public static class Mutable
    extends OrbData {
        public Mutable(String name, ResourceLocation type, int effectMultiplier, int effectDuration, String color, ResourceLocation texture, List<ResourceLocation> blockSet, String blockListType, double blockDropChance, List<ResourceLocation> entitySet, String entityListType, double entityDropChance) {
            super(name, type, effectMultiplier, effectDuration, color, texture, blockSet, blockListType, blockDropChance, entitySet, entityListType, entityDropChance);
        }

        public Mutable(String name) {
            super(name);
        }

        public Mutable setBlockDropChance(double blockDropChance) {
            this.blockDropChance = blockDropChance;
            return this;
        }

        public Mutable setEntityDropChance(double entityDropChance) {
            this.entityDropChance = entityDropChance;
            return this;
        }

        public Mutable setEffectMultiplier(int effectMultiplier) {
            this.effectMultiplier = effectMultiplier;
            return this;
        }

        public Mutable setEffectDuration(int effectDuration) {
            this.effectMultiplier = effectDuration;
            return this;
        }

        public Mutable setColor(String color) {
            this.color = color;
            return this;
        }

        public Mutable setBlockListType(String blockListType) {
            this.blockListType = blockListType;
            return this;
        }

        public Mutable setEntityListType(String entityListType) {
            this.entityListType = entityListType;
            return this;
        }

        public Mutable setBlockSet(List<ResourceLocation> blockSet) {
            this.blockSet = blockSet;
            return this;
        }

        public Mutable setName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public OrbData toImmutable() {
            return new OrbData(this.name, this.type, this.effectMultiplier, this.effectDuration, this.color, this.texture, this.blockSet, this.blockListType, this.blockDropChance, this.entitySet, this.entityListType, this.entityDropChance);
        }
    }
}

