/*
 * Decompiled with CFR 0.152.
 */
package com.decursioteam.pickableorbs.datagen;

import com.decursioteam.pickableorbs.PickableOrbs;
import com.decursioteam.pickableorbs.codec.ExtraOptions;
import com.decursioteam.pickableorbs.codec.OrbData;
import com.decursioteam.pickableorbs.datagen.OrbsData;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.registries.ForgeRegistries;
import org.antlr.v4.runtime.misc.NotNull;

public class Orbs {
    public static final Orbs DEFAULT = new Orbs(OrbData.DEFAULT, ExtraOptions.DEFAULT);
    protected OrbData orbData;
    protected ExtraOptions extraData;
    protected JsonObject rawData;
    protected ResourceLocation registryID;
    protected EntityType<?> entityType;
    protected MutableComponent displayName;

    public static Codec<Orbs> codec(String name) {
        return RecordCodecBuilder.create(instance -> instance.group((App)OrbData.codec(name).fieldOf("OrbData").orElseGet(s -> PickableOrbs.LOGGER.error("OrbData is REQUIRED!"), null).forGetter(Orbs::getData), (App)ExtraOptions.CODEC.fieldOf("ExtraData").orElse((Object)ExtraOptions.DEFAULT).forGetter(Orbs::getExtraData)).apply((Applicative)instance, Orbs::new));
    }

    private Orbs(OrbData orbData, ExtraOptions extraData) {
        this.orbData = orbData;
        this.extraData = extraData;
        this.rawData = OrbsData.getRegistry().getRawOrbsData(orbData.getName());
        this.registryID = new ResourceLocation("pickableorbs:" + orbData.getName() + "_orb");
        this.displayName = Component.m_237115_((String)("entity.pickableorbs." + orbData.getName() + "_orb"));
    }

    private Orbs(Mutable mutable) {
        this.extraData = mutable.extraData.toImmutable();
        this.orbData = mutable.orbData.toImmutable();
        this.rawData = mutable.rawData;
        this.registryID = mutable.registryID;
        this.entityType = mutable.entityType;
        this.displayName = mutable.displayName;
    }

    public OrbData getData() {
        return this.orbData;
    }

    public ExtraOptions getExtraData() {
        return this.extraData;
    }

    @NotNull
    public EntityType<?> getEntityType() {
        if (this.entityType == null) {
            this.entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(ResourceLocation.m_135820_((String)this.registryID.toString()));
        }
        return this.entityType == null ? EntityType.f_20570_ : this.entityType;
    }

    public ResourceLocation getRegistryID() {
        return this.registryID;
    }

    @Nullable
    public JsonObject getRawData() {
        return this.rawData;
    }

    public MutableComponent getDisplayName() {
        return this.displayName;
    }

    public Orbs toImmutable() {
        return this;
    }

    public static class Mutable
    extends Orbs {
        public Mutable(OrbData orbData, ExtraOptions extraData) {
            super(orbData, extraData);
        }

        public Mutable() {
            super(OrbData.DEFAULT, ExtraOptions.DEFAULT);
        }

        public Mutable setData(OrbData orbData) {
            this.orbData = orbData;
            return this;
        }

        public Mutable setData(ExtraOptions extraData) {
            this.extraData = extraData;
            return this;
        }

        public Mutable setRegistryID(ResourceLocation registryID) {
            this.registryID = registryID;
            return this;
        }

        public Mutable setDisplayName(TranslatableContents displayName) {
            this.displayName = MutableComponent.m_237204_((ComponentContents)displayName);
            return this;
        }

        public Mutable setRawData(JsonObject rawData) {
            this.rawData = rawData;
            return this;
        }

        public Mutable setEntityType(EntityType<?> entityType) {
            this.entityType = entityType;
            return this;
        }

        @Override
        public Orbs toImmutable() {
            return new Orbs(this);
        }
    }
}

