/*
 * Decompiled with CFR 0.152.
 */
package com.decursioteam.pickableorbs.datagen.utils;

import com.decursioteam.pickableorbs.PickableOrbs;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraftforge.fml.ModList;

public class FileUtils {
    public static final String JSON = ".json";
    public static final String ZIP = ".zip";
    public static final Path MOD_ROOT = ModList.get().getModFileById("pickableorbs").getFile().getFilePath();

    public static void streamFilesAndParse(Path directoryPath, BiConsumer<Reader, String> instructions, String errorMessage) {
        try (Stream<Path> zipStream = Files.walk(directoryPath, new FileVisitOption[0]);
             Stream<Path> jsonStream = Files.walk(directoryPath, new FileVisitOption[0]);){
            zipStream.filter(f -> f.getFileName().toString().endsWith(ZIP)).forEach(path -> FileUtils.addZippedFile(path, instructions));
            jsonStream.filter(f -> f.getFileName().toString().endsWith(JSON)).forEach(path -> FileUtils.addFile(path, instructions));
        }
        catch (IOException e) {
            PickableOrbs.LOGGER.error(errorMessage, (Throwable)e);
        }
    }

    public static void setupDefaultFiles(String dataPath, Path targetPath) {
        if (Files.isRegularFile(MOD_ROOT, new LinkOption[0])) {
            try (FileSystem fileSystem = FileSystems.newFileSystem(MOD_ROOT, ClassLoader.getSystemClassLoader());){
                Path path = fileSystem.getPath(dataPath, new String[0]);
                if (Files.exists(path, new LinkOption[0])) {
                    FileUtils.copyFiles(path, targetPath);
                }
            }
            catch (IOException e) {
                PickableOrbs.LOGGER.error("Could not load source {}!!", (Object)MOD_ROOT);
                e.printStackTrace();
            }
        } else if (Files.isDirectory(MOD_ROOT, new LinkOption[0])) {
            FileUtils.copyFiles(Paths.get(MOD_ROOT.toString(), dataPath), targetPath);
        }
    }

    private static void addFile(Path path, BiConsumer<Reader, String> instructions) {
        File f = path.toFile();
        try {
            FileUtils.parseType(f, instructions);
        }
        catch (IOException e) {
            PickableOrbs.LOGGER.warn("File not found: {}", (Object)path);
        }
    }

    private static void addZippedFile(Path file, BiConsumer<Reader, String> instructions) {
        try (ZipFile zf = new ZipFile(file.toString());){
            zf.stream().filter(zipEntry -> zipEntry.getName().endsWith(JSON)).forEach(zipEntry -> {
                try {
                    FileUtils.parseType(zf, zipEntry, instructions);
                }
                catch (IOException e) {
                    PickableOrbs.LOGGER.error("Could not parse zip entry: {}", (Object)zipEntry.getName());
                }
            });
        }
        catch (IOException e) {
            PickableOrbs.LOGGER.warn("Could not read Zip File: {}", (Object)file.getFileName());
        }
    }

    private static void parseType(File file, BiConsumer<Reader, String> consumer) throws IOException {
        String name = file.getName();
        name = name.substring(0, name.indexOf(46));
        BufferedReader r = Files.newBufferedReader(file.toPath());
        consumer.accept(r, name);
    }

    private static void parseType(ZipFile zf, ZipEntry zipEntry, BiConsumer<Reader, String> consumer) throws IOException {
        String name = zipEntry.getName();
        name = name.substring(name.lastIndexOf("/") + 1, name.indexOf(46));
        InputStream input = zf.getInputStream(zipEntry);
        BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
        consumer.accept(reader, name);
    }

    private static void copyFiles(Path source, Path targetPath) {
        try (Stream<Path> sourceStream = Files.walk(source, new FileVisitOption[0]);){
            sourceStream.filter(f -> f.getFileName().toString().endsWith(JSON)).forEach(path -> {
                try {
                    Files.copy(path, Paths.get(targetPath.toString(), path.getFileName().toString()), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    PickableOrbs.LOGGER.error("Could not copy file: {}, Target: {}", path, (Object)targetPath);
                }
            });
        }
        catch (IOException e) {
            PickableOrbs.LOGGER.error("Could not stream source files: {}", (Object)source);
        }
    }
}

