/*
 * Decompiled with CFR 0.152.
 */
package com.decursioteam.pickableorbs.entities;

import com.decursioteam.pickableorbs.PickableOrbs;
import com.decursioteam.pickableorbs.datagen.Orbs;
import com.decursioteam.pickableorbs.datagen.OrbsData;
import com.decursioteam.pickableorbs.registries.Registry;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;

public class HalfHeartEntity
extends Entity {
    public int f_19797_;
    public int age;
    public int throwTime;
    private int health = 5;
    protected final Orbs orbData;
    protected final String orbType;
    private Player followingPlayer;
    private int followingTime;

    public HalfHeartEntity(EntityType<HalfHeartEntity> type, Level world, double x, double y, double z, String orbType, Orbs orbData) {
        super(type, world);
        this.orbData = orbData;
        this.orbType = orbType;
        this.m_6034_(x, y, z);
        this.f_19859_ = (float)(this.f_19796_.m_188500_() * 360.0);
        this.m_20334_((this.f_19796_.m_188500_() * (double)0.2f - (double)0.1f) * 2.0, this.f_19796_.m_188500_() * 0.2 * 2.0, (this.f_19796_.m_188500_() * (double)0.2f - (double)0.1f) * 2.0);
    }

    public HalfHeartEntity(EntityType<HalfHeartEntity> type, Level world, String orbType) {
        super(type, world);
        this.orbType = orbType;
        this.orbData = OrbsData.getOrbData(orbType);
    }

    protected boolean isMovementNoisy() {
        return false;
    }

    protected void m_8097_() {
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.throwTime > 0) {
            --this.throwTime;
        }
        this.f_19854_ = this.m_20185_();
        this.f_19855_ = this.m_20186_();
        this.f_19856_ = this.m_20189_();
        if (this.m_204029_(FluidTags.f_13131_)) {
            this.setUnderwaterMovement();
        } else if (!this.m_20068_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.03, 0.0));
        }
        if (this.f_19853_.m_6425_(this.m_20183_()).m_205070_(FluidTags.f_13132_)) {
            this.m_20334_((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f, 0.2f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f);
            this.m_5496_(SoundEvents.f_11909_, 0.4f, 2.0f + this.f_19796_.m_188501_() * 0.4f);
        }
        if (!this.f_19853_.m_45772_(this.m_20191_())) {
            this.m_20314_(this.m_20185_(), (this.m_20191_().f_82289_ + this.m_20191_().f_82292_) / 2.0, this.m_20189_());
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        float f = 0.98f;
        if (this.f_19861_) {
            BlockPos pos = new BlockPos((int)this.m_20185_(), (int)(this.m_20186_() - 1.0), (int)this.m_20189_());
            f = this.f_19853_.m_8055_(pos).getFriction((LevelReader)this.f_19853_, pos, (Entity)this) * 0.98f;
        }
        this.m_20256_(this.m_20184_().m_82542_((double)f, 0.98, (double)f));
        if (this.f_19861_) {
            this.m_20256_(this.m_20184_().m_82542_(1.0, -0.9, 1.0));
        }
        if (this.orbData.getExtraData().getFollowPlayer()) {
            Vec3 vector3d;
            double d1;
            if (this.followingTime < this.f_19797_ - 20 + this.m_19879_() % 100) {
                if (this.followingPlayer == null || this.followingPlayer.m_20280_((Entity)this) > 64.0) {
                    this.followingPlayer = this.f_19853_.m_45930_((Entity)this, 8.0);
                }
                this.followingTime = this.f_19797_;
            }
            if (this.followingPlayer != null && this.followingPlayer.m_5833_()) {
                this.followingPlayer = null;
            }
            if (this.followingPlayer != null && (d1 = (vector3d = new Vec3(this.followingPlayer.m_20185_() - this.m_20185_(), this.followingPlayer.m_20186_() + (double)this.followingPlayer.m_20192_() / 2.0 - this.m_20186_(), this.followingPlayer.m_20189_() - this.m_20189_())).m_82556_()) < 64.0) {
                double d2 = 1.0 - Math.sqrt(d1) / 8.0;
                this.m_20256_(this.m_20184_().m_82549_(vector3d.m_82541_().m_82490_(d2 * d2 * 0.1)));
            }
        }
        ++this.f_19797_;
        ++this.age;
        if (this.age >= 6000) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    private void setUnderwaterMovement() {
        Vec3 vector3d = this.m_20184_();
        this.m_20334_(vector3d.f_82479_ * (double)0.99f, Math.min(vector3d.f_82480_ + (double)5.0E-4f, (double)0.06f), vector3d.f_82481_ * (double)0.99f);
    }

    protected void m_5841_() {
    }

    public boolean m_6469_(DamageSource p_70097_1_, float p_70097_2_) {
        if (this.f_19853_.f_46443_ || this.m_213877_()) {
            return false;
        }
        if (this.m_6673_(p_70097_1_)) {
            return false;
        }
        this.m_5834_();
        this.health = (int)((float)this.health - p_70097_2_);
        if (this.health <= 0) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
        return false;
    }

    public void m_6123_(Player playerEntity) {
        if (!this.f_19853_.f_46443_ && this.throwTime == 0 && this.age >= this.orbData.getExtraData().getPickupDelay()) {
            playerEntity.m_7938_((Entity)this, 1);
            int effectMultiplier = this.orbData.getData().getEffectMultiplier();
            int effectDuration = this.orbData.getData().getEffectDuration();
            if (Objects.equals(this.orbData.getData().getType(), new ResourceLocation("pickableorbs:percentage_healing"))) {
                playerEntity.m_5634_((float)((double)(playerEntity.m_21233_() * (float)this.orbData.getData().getEffectMultiplier()) / 100.0));
            } else {
                try {
                    playerEntity.m_7292_(new MobEffectInstance(Objects.requireNonNull((MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(this.orbData.getData().getType())), effectDuration, effectMultiplier));
                }
                catch (Exception e) {
                    PickableOrbs.LOGGER.error("[PickableOrbs] - The orb type of: " + this.orbData.getData().getName() + " is invalid.");
                }
            }
            if (!this.orbData.getExtraData().getPickupMessage().isEmpty()) {
                playerEntity.m_5661_((Component)Component.m_237113_((String)this.orbData.getExtraData().getPickupMessage()), true);
            }
            if (this.orbData.getExtraData().getSound()) {
                this.m_5496_((SoundEvent)Registry.GET_HEART_SOUND.get(), 0.4f, 0.95f);
            }
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public void m_7380_(CompoundTag p_213281_1_) {
        p_213281_1_.m_128376_("Health", (short)this.health);
        p_213281_1_.m_128376_("Age", (short)this.age);
    }

    public void m_7378_(CompoundTag p_70037_1_) {
        this.health = p_70037_1_.m_128448_("Health");
        this.age = p_70037_1_.m_128448_("Age");
    }

    public boolean m_6097_() {
        return false;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

