/*
 * Decompiled with CFR 0.152.
 */
package com.teampotato.piglinsafety;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Set;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class ConfigSetup
implements IMixinConfigPlugin {
    private static boolean piglin;
    private static boolean hoglin;
    private static boolean piglinBrute;

    public ConfigSetup() {
        File file = FMLPaths.CONFIGDIR.get().resolve("piglinsafety.json").toFile();
        if (!file.exists()) {
            try {
                FileWriter writer = ConfigSetup.writeFile(file);
                writer.close();
            }
            catch (IOException e) {
                LogManager.getLogger().error("Error writing config", (Throwable)e);
            }
        }
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            JsonObject config = new JsonParser().parse((Reader)reader).getAsJsonObject();
            piglin = config.get("Piglin").getAsBoolean();
            hoglin = config.get("Hoglin").getAsBoolean();
            piglinBrute = config.get("PiglinBrute").getAsBoolean();
            reader.close();
        }
        catch (IOException e) {
            LogManager.getLogger().error("Error reading config", (Throwable)e);
        }
    }

    private static FileWriter writeFile(File file) throws IOException {
        JsonObject defaultConfig = new JsonObject();
        defaultConfig.addProperty("Piglin", Boolean.valueOf(true));
        defaultConfig.addProperty("Hoglin", Boolean.valueOf(true));
        defaultConfig.addProperty("PiglinBrute", Boolean.valueOf(true));
        FileWriter writer = new FileWriter(file);
        writer.write(defaultConfig.toString());
        return writer;
    }

    public boolean shouldApplyMixin(String s, String mixinClassName) {
        if (mixinClassName.contains("PiglinBrute")) {
            return piglinBrute;
        }
        if (mixinClassName.contains("Piglin")) {
            return piglin;
        }
        if (mixinClassName.contains("Hoglin")) {
            return hoglin;
        }
        return true;
    }

    public void onLoad(String s) {
    }

    public String getRefMapperConfig() {
        return null;
    }

    public void acceptTargets(Set<String> set, Set<String> set1) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String s, ClassNode classNode, String s1, IMixinInfo iMixinInfo) {
    }

    public void postApply(String s, ClassNode classNode, String s1, IMixinInfo iMixinInfo) {
    }
}

