/*
 * Decompiled with CFR 0.152.
 */
package com.teampotato.potacore.iteration;

import com.teampotato.potacore.iteration.CloseableIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilterableIterator<K>
implements CloseableIterator<K> {
    @Nullable
    private Predicate<K> filter;
    @Nullable
    private Iterator<K> iterator;
    @Nullable
    private K next;

    public FilterableIterator(@NotNull Iterator<K> iterator, @NotNull Predicate<K> filter) {
        this.filter = filter;
        this.iterator = iterator;
    }

    private void advance() {
        block3: {
            if (this.iterator == null || this.filter == null) {
                return;
            }
            while (this.iterator.hasNext()) {
                K candidate = this.iterator.next();
                if (this.filter.test(candidate)) {
                    this.next = candidate;
                    break block3;
                }
                this.next = null;
            }
            this.next = null;
        }
    }

    @Override
    public boolean hasNext() {
        this.advance();
        return this.next != null;
    }

    @Override
    public K next() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        return this.next;
    }

    @Override
    public void forEachRemaining(@NotNull Consumer<? super K> action) {
        while (this.hasNext()) {
            action.accept(this.next());
        }
    }

    @Override
    public void remove() {
        if (this.iterator == null) {
            return;
        }
        this.iterator.remove();
    }

    @Override
    public void close() {
        CloseableIterator.close(this.iterator);
        this.next = null;
        this.iterator = null;
        this.filter = null;
    }
}

