/*
 * Decompiled with CFR 0.152.
 */
package com.recipeessentials.recipecache;

import com.recipeessentials.RecipeEssentials;
import com.recipeessentials.config.CommonConfiguration;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;

public class CachedRecipeList {
    public final List<Recipe> recipes;
    public final List<ItemStack> originStacks;
    public final RecipeType originType;
    public int useCount = 0;
    public boolean reported = false;

    public CachedRecipeList(List<Recipe> recipes, List<ItemStack> originStacks, RecipeType originType) {
        this.recipes = recipes;
        this.originStacks = originStacks;
        this.originType = originType;
    }

    public <T extends Recipe<C>, C extends Container> CachedRecipeList(RecipeType<T> recipeTypeIn, C inventoryIn) {
        this.originType = recipeTypeIn;
        this.recipes = new ArrayList<Recipe>();
        this.originStacks = new ArrayList<ItemStack>();
        if (inventoryIn != null) {
            for (int i = 0; i < inventoryIn.m_6643_(); ++i) {
                ItemStack stack = inventoryIn.m_8020_(i);
                if (stack == null || stack.m_41619_()) continue;
                this.originStacks.add(stack.m_41777_());
            }
        }
    }

    public <T extends Recipe<C>, C extends Container> void report(RecipeType<T> recipeTypeIn, C inventoryIn, List<T> recipes) {
        if (!this.reported && ((CommonConfiguration)RecipeEssentials.config.getCommonConfig()).logCachingErrors) {
            this.reported = true;
            CachedRecipeList temp = new CachedRecipeList(recipeTypeIn, inventoryIn);
            RecipeEssentials.LOGGER.warn("Unable to optimize some recipes, printing mismatch");
            RecipeEssentials.LOGGER.warn("Mismatching cached recipe lists for input: type:" + recipeTypeIn + " stacks:" + temp.originStacks);
            RecipeEssentials.LOGGER.warn("Result recipe list:" + recipes.stream().map(Recipe::m_6423_).toList());
            RecipeEssentials.LOGGER.warn("Cached values: type:" + this.originType + " stacks:" + this.originStacks);
            RecipeEssentials.LOGGER.warn("Cached recipe list:" + this.recipes.stream().map(Recipe::m_6423_).toList());
        }
        this.useCount = 0;
    }
}

