/*
 * Decompiled with CFR 0.152.
 */
package link.infra.indium.renderer.render;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.function.Function;
import link.infra.indium.other.SpriteFinderCache;
import link.infra.indium.renderer.mesh.MutableQuadViewImpl;
import link.infra.indium.renderer.render.BaseQuadRenderer;
import me.jellysquid.mods.sodium.client.render.texture.SpriteUtil;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;

public abstract class VertexConsumerQuadBufferer
implements BaseQuadRenderer.QuadBufferer {
    protected final Function<RenderType, VertexConsumer> bufferFunc;
    protected final Vector3f normalVec = new Vector3f();

    protected abstract Matrix4f matrix();

    protected abstract Matrix3f normalMatrix();

    protected abstract int overlay();

    VertexConsumerQuadBufferer(Function<RenderType, VertexConsumer> bufferFunc) {
        this.bufferFunc = bufferFunc;
    }

    @Override
    public void bufferQuad(MutableQuadViewImpl quad, RenderType renderLayer) {
        VertexConsumerQuadBufferer.bufferQuad(this.bufferFunc.apply(renderLayer), quad, this.matrix(), this.overlay(), this.normalMatrix(), this.normalVec);
    }

    public static void bufferQuad(VertexConsumer buff, MutableQuadViewImpl quad, Matrix4f matrix, int overlay, Matrix3f normalMatrix, Vector3f normalVec) {
        boolean useNormals = quad.hasVertexNormals();
        if (useNormals) {
            quad.populateMissingNormals();
        } else {
            Vector3f faceNormal = quad.faceNormal();
            normalVec.m_122245_(faceNormal.m_122239_(), faceNormal.m_122260_(), faceNormal.m_122269_());
            normalVec.m_122249_(normalMatrix);
        }
        for (int i = 0; i < 4; ++i) {
            buff.m_85982_(matrix, quad.x(i), quad.y(i), quad.z(i));
            int color = quad.spriteColor(i, 0);
            buff.m_6122_(color & 0xFF, color >> 8 & 0xFF, color >> 16 & 0xFF, color >> 24 & 0xFF);
            buff.m_7421_(quad.spriteU(i, 0), quad.spriteV(i, 0));
            buff.m_86008_(overlay);
            buff.m_85969_(quad.lightmap(i));
            if (useNormals) {
                normalVec.m_122245_(quad.normalX(i), quad.normalY(i), quad.normalZ(i));
                normalVec.m_122249_(normalMatrix);
            }
            buff.m_5601_(normalVec.m_122239_(), normalVec.m_122260_(), normalVec.m_122269_());
            buff.m_5752_();
        }
        TextureAtlasSprite sprite = quad.cachedSprite();
        if (sprite == null) {
            sprite = SpriteFinderCache.forBlockAtlas().find(quad, 0);
        }
        SpriteUtil.markSpriteActive((TextureAtlasSprite)sprite);
    }
}

