/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.salt;

import io.github.mortuusars.salt.Salt;
import io.github.mortuusars.salt.block.ISaltBlock;
import io.github.mortuusars.salt.configuration.Configuration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;

public class Dissolving {
    public static boolean maybeDissolveInRain(BlockState dissolvedState, ServerLevel level, BlockPos pos) {
        if (((Boolean)Configuration.DISSOLVING_ENABLED.get()).booleanValue() && ((Boolean)Configuration.DISSOLVING_IN_RAIN.get()).booleanValue() && level.m_46758_(pos.m_7494_()) && level.f_46441_.m_188500_() < (Double)Configuration.DISSOLVING_IN_RAIN_CHANCE.get()) {
            Dissolving.dissolve(dissolvedState, level, pos, Fluids.f_76191_, false);
            return true;
        }
        return false;
    }

    public static boolean maybeDissolve(BlockState dissolvedState, BlockPos dissolvedPos, BlockState adjacentState, BlockPos adjacentPos, ServerLevel level) {
        if (((Boolean)Configuration.DISSOLVING_ENABLED.get()).booleanValue() && adjacentState.m_204336_(Salt.BlockTags.SALT_DISSOLVABLES) && level.f_46441_.m_188500_() < (Double)Configuration.DISSOLVING_CHANCE.get()) {
            FluidState fluidState = adjacentState.m_60819_();
            if (dissolvedPos.m_123342_() > adjacentPos.m_123342_()) {
                fluidState = Fluids.f_76191_.m_76145_();
            }
            Dissolving.dissolve(dissolvedState, level, dissolvedPos, fluidState.m_76152_(), fluidState.m_76170_());
            return true;
        }
        return false;
    }

    public static void dissolve(BlockState state, ServerLevel level, BlockPos pos, Fluid fluid, boolean isSource) {
        BlockState dissolvedState;
        Block block = state.m_60734_();
        if (block instanceof ISaltBlock) {
            ISaltBlock saltBlock = (ISaltBlock)block;
            v0 = saltBlock.getDissolvedState(state, level, pos, fluid);
        } else {
            v0 = dissolvedState = Blocks.f_50016_.m_49966_();
        }
        if (Dissolving.shouldPlaceFluidSource(level, pos, fluid, isSource)) {
            if (dissolvedState.m_60795_()) {
                dissolvedState = fluid.m_76145_().m_76188_();
            } else {
                SimpleWaterloggedBlock waterloggedBlock;
                block = dissolvedState.m_60734_();
                if (block instanceof SimpleWaterloggedBlock && (waterloggedBlock = (SimpleWaterloggedBlock)block).m_6044_((BlockGetter)level, pos, dissolvedState, fluid)) {
                    dissolvedState = (BlockState)dissolvedState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true));
                }
            }
        }
        level.m_46597_(pos, dissolvedState);
        Dissolving.onBlockDissolved(level, pos);
    }

    private static boolean shouldPlaceFluidSource(ServerLevel level, BlockPos pos, Fluid fluid, boolean isSource) {
        return (Boolean)Configuration.DISSOLVING_FLUID_SOURCE_CONVERSION.get() != false && fluid == Fluids.f_76193_ && isSource;
    }

    private static void onBlockDissolved(ServerLevel level, BlockPos pos) {
        Vec3 center = Vec3.m_82512_((Vec3i)pos);
        RandomSource random = level.m_213780_();
        level.m_6263_(null, center.f_82479_, center.f_82480_, center.f_82481_, (SoundEvent)Salt.Sounds.SALT_DISSOLVE.get(), SoundSource.BLOCKS, 1.0f, random.m_188501_() * 0.2f + 0.9f);
        for (int i = 0; i < 6; ++i) {
            level.m_8767_((ParticleOptions)ParticleTypes.f_123764_, center.f_82479_ + random.m_188583_() * (double)0.35f, center.f_82480_ + random.m_188583_() * (double)0.35f, center.f_82481_ + random.m_188583_() * (double)0.35f, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }
}

