/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.salt.block;

import io.github.mortuusars.salt.Dissolving;
import io.github.mortuusars.salt.Melting;
import io.github.mortuusars.salt.Salt;
import io.github.mortuusars.salt.block.SaltClusterBlock;
import io.github.mortuusars.salt.configuration.Configuration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public interface ISaltBlock {
    @NotNull
    public BlockState getDissolvedState(BlockState var1, ServerLevel var2, BlockPos var3, Fluid var4);

    default public boolean onSaltRandomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        ArrayList directions = Arrays.stream(Direction.values()).collect(Collectors.toCollection(ArrayList::new));
        Collections.shuffle(directions);
        for (Direction direction : directions) {
            BlockPos adjacentPos = pos.m_121945_(direction);
            BlockState adjacentState = level.m_8055_(adjacentPos);
            if (Melting.tryMeltFromBlock(adjacentPos, level)) break;
            if (direction == Direction.DOWN || !Dissolving.maybeDissolve(state, pos, adjacentState, adjacentPos, level)) continue;
            return false;
        }
        if (Dissolving.maybeDissolveInRain(this.getDissolvedState(state, level, pos, (Fluid)Fluids.f_76193_), level, pos)) {
            return false;
        }
        ISaltBlock.maybeGrowCluster(state, pos, level);
        return true;
    }

    default public void onSaltAnimateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        Direction direction;
        if (random.m_188503_(3) == 0 && level.m_46758_(pos.m_7494_()) && (direction = Direction.m_235672_((RandomSource)random)) != Direction.UP) {
            BlockPos blockpos = pos.m_121945_(direction);
            BlockState blockstate = level.m_8055_(blockpos);
            if (!state.m_60815_() || !blockstate.m_60783_((BlockGetter)level, blockpos, direction.m_122424_())) {
                double d0 = direction.m_122429_() == 0 ? random.m_188500_() : 0.5 + (double)direction.m_122429_() * 0.65;
                double d1 = direction.m_122430_() == 0 ? random.m_188500_() : 0.5 + (double)direction.m_122430_() * 0.65;
                double d2 = direction.m_122431_() == 0 ? random.m_188500_() : 0.5 + (double)direction.m_122431_() * 0.65;
                level.m_7106_((ParticleOptions)ParticleTypes.f_123764_, (double)pos.m_123341_() + d0, (double)pos.m_123342_() + d1, (double)pos.m_123343_() + d2, 0.0, 0.0, 0.0);
            }
        }
    }

    public static void maybeGrowCluster(BlockState baseState, BlockPos basePos, ServerLevel level) {
        BlockPos clusterPos;
        if (baseState.m_204336_(Salt.BlockTags.SALT_CLUSTER_GROWABLES) && ((Boolean)Configuration.SALT_CLUSTER_GROWING_ENABLED.get()).booleanValue() && (double)level.f_46441_.m_188501_() < (Double)Configuration.SALT_CLUSTER_GROWING_CHANCE.get() && ISaltBlock.canGrowCluster(clusterPos = basePos.m_7494_(), level)) {
            Fluid drippingFluid = ISaltBlock.getFluidDrippingOn(level, clusterPos);
            if (drippingFluid == Fluids.f_76193_) {
                ISaltBlock.growCluster(baseState, basePos, level);
            } else if (drippingFluid != Fluids.f_76191_) {
                level.m_46961_(clusterPos, false);
            }
        }
    }

    public static Fluid getFluidDrippingOn(ServerLevel level, BlockPos pos) {
        BlockPos blockpos = PointedDripstoneBlock.m_154055_((Level)level, (BlockPos)pos);
        return blockpos == null ? Fluids.f_76191_ : PointedDripstoneBlock.m_221849_((ServerLevel)level, (BlockPos)blockpos);
    }

    public static boolean canGrowCluster(BlockPos clusterPos, ServerLevel level) {
        BlockState blockStateAbove = level.m_8055_(clusterPos);
        return blockStateAbove.m_60795_() || blockStateAbove.m_60734_() instanceof SaltClusterBlock && !blockStateAbove.m_60713_((Block)Salt.Blocks.SALT_CLUSTER.get());
    }

    public static void growCluster(BlockState state, BlockPos basePos, ServerLevel level) {
        BlockPos clusterPos = basePos.m_7494_();
        BlockState prevState = level.m_8055_(clusterPos);
        BlockState clusterState = prevState.m_60795_() ? ((SaltClusterBlock)Salt.Blocks.SMALL_SALT_BUD.get()).m_49966_() : (prevState.m_60713_((Block)Salt.Blocks.SMALL_SALT_BUD.get()) ? ((SaltClusterBlock)Salt.Blocks.MEDIUM_SALT_BUD.get()).m_49966_() : (prevState.m_60713_((Block)Salt.Blocks.MEDIUM_SALT_BUD.get()) ? ((SaltClusterBlock)Salt.Blocks.LARGE_SALT_BUD.get()).m_49966_() : ((SaltClusterBlock)Salt.Blocks.SALT_CLUSTER.get()).m_49966_()));
        level.m_46597_(clusterPos, (BlockState)clusterState.m_61124_((Property)SaltClusterBlock.FACING, (Comparable)Direction.UP));
        Random random = new Random();
        level.m_5594_(null, clusterPos, (SoundEvent)Salt.Sounds.SALT_CLUSTER_FALL.get(), SoundSource.BLOCKS, 0.3f, random.nextFloat() * 0.3f + 0.75f);
        BlockState placedClusterState = level.m_8055_(clusterPos);
        BlockParticleOption particleType = new BlockParticleOption(ParticleTypes.f_123794_, placedClusterState);
        VoxelShape shape = placedClusterState.m_60808_((BlockGetter)level, clusterPos);
        for (int i = 0; i < 8; ++i) {
            level.m_8767_((ParticleOptions)particleType, (double)clusterPos.m_123341_() + random.nextDouble(shape.m_83288_(Direction.Axis.X), shape.m_83297_(Direction.Axis.X)), (double)clusterPos.m_123342_() + random.nextDouble(shape.m_83288_(Direction.Axis.Y), shape.m_83297_(Direction.Axis.Y)), (double)clusterPos.m_123343_() + random.nextDouble(shape.m_83288_(Direction.Axis.Z), shape.m_83297_(Direction.Axis.Z)), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }
}

