/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.salt.block;

import io.github.mortuusars.salt.Dissolving;
import io.github.mortuusars.salt.Melting;
import io.github.mortuusars.salt.Salt;
import io.github.mortuusars.salt.block.ISaltBlock;
import io.github.mortuusars.salt.configuration.Configuration;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class SaltClusterBlock
extends Block
implements ISaltBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    protected final VoxelShape northAabb;
    protected final VoxelShape southAabb;
    protected final VoxelShape eastAabb;
    protected final VoxelShape westAabb;
    protected final VoxelShape upAabb;
    protected final VoxelShape downAabb;

    public SaltClusterBlock(int size, int offset, BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.UP));
        this.upAabb = Block.m_49796_((double)offset, (double)0.0, (double)offset, (double)(16 - offset), (double)size, (double)(16 - offset));
        this.downAabb = Block.m_49796_((double)offset, (double)(16 - size), (double)offset, (double)(16 - offset), (double)16.0, (double)(16 - offset));
        this.northAabb = Block.m_49796_((double)offset, (double)offset, (double)(16 - size), (double)(16 - offset), (double)(16 - offset), (double)16.0);
        this.southAabb = Block.m_49796_((double)offset, (double)offset, (double)0.0, (double)(16 - offset), (double)(16 - offset), (double)size);
        this.eastAabb = Block.m_49796_((double)0.0, (double)offset, (double)offset, (double)size, (double)(16 - offset), (double)(16 - offset));
        this.westAabb = Block.m_49796_((double)(16 - size), (double)offset, (double)offset, (double)16.0, (double)(16 - offset), (double)(16 - offset));
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (!player.m_7500_() && ((Boolean)Configuration.SALT_CLUSTER_GROWING_ENABLED.get()).booleanValue() && state.m_60713_((Block)Salt.Blocks.SALT_CLUSTER.get()) && level.m_8055_(pos.m_7495_()).m_204336_(Salt.BlockTags.SALT_CLUSTER_GROWABLES) && ISaltBlock.getFluidDrippingOn(serverLevel, pos) == Fluids.f_76193_) {
                    Salt.Advancements.HARVEST_SALT_CRYSTAL.trigger(serverPlayer);
                }
            }
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    public void m_5581_(Level level, BlockState blockState, BlockHitResult blockHitResult, Projectile projectile) {
        BlockPos blockpos = blockHitResult.m_82425_();
        if (!level.f_46443_ && projectile.m_142265_(level, blockpos) && projectile instanceof ThrownTrident && projectile.m_20184_().m_82553_() > 0.6) {
            level.m_46961_(blockpos, true);
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!level.f_46443_ && !newState.m_60819_().m_192917_(Fluids.f_76191_)) {
            level.m_5594_(null, pos, (SoundEvent)Salt.Sounds.SALT_DISSOLVE.get(), SoundSource.BLOCKS, 0.8f, level.m_213780_().m_188501_() * 0.2f + 0.9f);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        this.onSaltAnimateTick(state, level, pos, random);
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockPos basePos = pos.m_121945_(((Direction)state.m_61143_((Property)FACING)).m_122424_());
        if (Melting.tryMeltFromBlock(basePos, level)) {
            return;
        }
        if (Dissolving.maybeDissolve(Blocks.f_50016_.m_49966_(), pos, level.m_8055_(basePos), basePos, level)) {
            return;
        }
        if (Dissolving.maybeDissolveInRain(this.getDissolvedState(state, level, pos, (Fluid)Fluids.f_76193_), level, pos)) {
            return;
        }
        if (state.m_61143_((Property)FACING) == Direction.UP) {
            BlockPos belowPos = pos.m_7495_();
            ISaltBlock.maybeGrowCluster(level.m_8055_(belowPos), belowPos, level);
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        VoxelShape shape = switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> this.downAabb;
            case Direction.UP -> this.upAabb;
            case Direction.NORTH -> this.northAabb;
            case Direction.SOUTH -> this.southAabb;
            case Direction.WEST -> this.westAabb;
            case Direction.EAST -> this.eastAabb;
        };
        return shape;
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockPos blockpos = pos.m_121945_(direction.m_122424_());
        return level.m_8055_(blockpos).m_60783_((BlockGetter)level, blockpos, direction);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        return direction == ((Direction)state.m_61143_((Property)FACING)).m_122424_() && !state.m_60710_((LevelReader)pLevel, pCurrentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, direction, neighborState, pLevel, pCurrentPos, pNeighborPos);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_43719_());
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING});
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.DESTROY;
    }

    @Override
    @NotNull
    public BlockState getDissolvedState(BlockState originalState, ServerLevel level, BlockPos pos, Fluid fluid) {
        return Blocks.f_50016_.m_49966_();
    }
}

