/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.salt.event;

import io.github.mortuusars.salt.Salt;
import io.github.mortuusars.salt.Salting;
import io.github.mortuusars.salt.integration.AppleSkinHandler;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="salt", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientEvents {
    public static void onClientSetup(FMLClientSetupEvent ignoredEvent) {
        if (ModList.get().isLoaded("appleskin")) {
            MinecraftForge.EVENT_BUS.register((Object)new AppleSkinHandler());
        }
    }

    @SubscribeEvent
    public static void registerModels(ModelEvent.RegisterAdditional event) {
        event.register(Salt.resource("item/salted_overlay"));
    }

    public static void onItemTooltipEvent(ItemTooltipEvent event) {
        ItemStack itemStack = event.getItemStack();
        if (Salting.isSalted(itemStack)) {
            List toolTip = event.getToolTip();
            Salting.FoodValue additionalFoodValue = Salting.getAdditionalFoodValue(itemStack);
            toolTip.add(toolTip.size() >= 1 ? 1 : 0, SaltedTooltip.get(additionalFoodValue.nutrition(), additionalFoodValue.saturationModifier(), Screen.m_96638_() && !ModList.get().isLoaded("appleskin")));
        }
    }

    public static class SaltedTooltip {
        public static final Style SALTED_STYLE = Style.f_131099_.m_178520_(15784149);
        public static final Style SALTED_EXPANDED_PART_STYLE = Style.f_131099_.m_178520_(13088693);

        public static MutableComponent get(int nutrition, float saturationModifier, boolean isExpanded) {
            MutableComponent base = Component.m_237115_((String)"gui.salt.tooltip.salted").m_130948_(SALTED_STYLE);
            return isExpanded ? base.m_7220_((Component)Component.m_237110_((String)"gui.salt.tooltip.salted_expanded_part", (Object[])new Object[]{nutrition > 0 ? "+" + nutrition : "-" + nutrition, saturationModifier > 0.0f ? "+" + saturationModifier : "-" + saturationModifier}).m_130948_(SALTED_EXPANDED_PART_STYLE)) : base;
        }
    }
}

