/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.salt.world.feature;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import io.github.mortuusars.salt.Salt;
import io.github.mortuusars.salt.world.feature.configurations.MineralDepositConfiguration;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.BulkSectionAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class MineralDepositFeature
extends Feature<MineralDepositConfiguration> {
    public MineralDepositFeature(Codec<MineralDepositConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<MineralDepositConfiguration> context) {
        RandomSource random = context.m_225041_();
        BlockPos origin = context.m_159777_();
        WorldGenLevel worldgenlevel = context.m_159774_();
        if (!worldgenlevel.m_204166_(origin).m_203656_(Salt.BiomeTags.HAS_ROCK_SALT_DEPOSITS)) {
            return false;
        }
        MineralDepositConfiguration configuration = (MineralDepositConfiguration)context.m_159778_();
        float f = random.m_188501_() * (float)Math.PI;
        float f1 = (float)configuration.getSize() / 8.0f;
        int i = Mth.m_14167_((float)(((float)configuration.getSize() / 16.0f * 2.0f + 1.0f) / 2.0f));
        double minX = (double)origin.m_123341_() + Math.sin(f) * (double)f1;
        double maxX = (double)origin.m_123341_() - Math.sin(f) * (double)f1;
        double minZ = (double)origin.m_123343_() + Math.cos(f) * (double)f1;
        double maxZ = (double)origin.m_123343_() - Math.cos(f) * (double)f1;
        double mixY = origin.m_123342_() + random.m_188503_(3) - 2;
        double maxY = origin.m_123342_() + random.m_188503_(3) - 2;
        int x = origin.m_123341_() - Mth.m_14167_((float)f1) - i;
        int y = origin.m_123342_() - 2 - i;
        int z = origin.m_123343_() - Mth.m_14167_((float)f1) - i;
        int width = 2 * (Mth.m_14167_((float)f1) + i);
        int height = 2 * (2 + i);
        for (int l1 = x; l1 <= x + width; ++l1) {
            for (int i2 = z; i2 <= z + width; ++i2) {
                if (y > worldgenlevel.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, l1, i2)) continue;
                return this.doPlace(worldgenlevel, random, configuration, minX, maxX, minZ, maxZ, mixY, maxY, x, y, z, width, height);
            }
        }
        return false;
    }

    protected boolean doPlace(WorldGenLevel level, RandomSource random, MineralDepositConfiguration configuration, double pMinX, double pMaxX, double pMinZ, double pMaxZ, double pMinY, double pMaxY, int pX, int pY, int pZ, int pWidth, int pHeight) {
        int placedBlocks = 0;
        BitSet bitset = new BitSet(pWidth * pHeight * pWidth);
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        int size = configuration.getSize();
        double[] adouble = new double[size * 4];
        for (int k = 0; k < size; ++k) {
            float f = (float)k / (float)size;
            double d0 = Mth.m_14139_((double)f, (double)pMinX, (double)pMaxX);
            double d1 = Mth.m_14139_((double)f, (double)pMinY, (double)pMaxY);
            double d2 = Mth.m_14139_((double)f, (double)pMinZ, (double)pMaxZ);
            double d3 = random.m_188500_() * (double)size / 16.0;
            double d4 = ((double)(Mth.m_14031_((float)((float)Math.PI * f)) + 1.0f) * d3 + 1.0) / 2.0;
            adouble[k * 4 + 0] = d0;
            adouble[k * 4 + 1] = d1;
            adouble[k * 4 + 2] = d2;
            adouble[k * 4 + 3] = d4;
        }
        for (int l3 = 0; l3 < size - 1; ++l3) {
            if (adouble[l3 * 4 + 3] <= 0.0) continue;
            for (int i4 = l3 + 1; i4 < size; ++i4) {
                double d12;
                double d10;
                double d8;
                double d14;
                if (adouble[i4 * 4 + 3] <= 0.0 || !((d14 = adouble[l3 * 4 + 3] - adouble[i4 * 4 + 3]) * d14 > (d8 = adouble[l3 * 4 + 0] - adouble[i4 * 4 + 0]) * d8 + (d10 = adouble[l3 * 4 + 1] - adouble[i4 * 4 + 1]) * d10 + (d12 = adouble[l3 * 4 + 2] - adouble[i4 * 4 + 2]) * d12)) continue;
                if (d14 > 0.0) {
                    adouble[i4 * 4 + 3] = -1.0;
                    continue;
                }
                adouble[l3 * 4 + 3] = -1.0;
            }
        }
        try (BulkSectionAccess bulksectionaccess = new BulkSectionAccess((LevelAccessor)level);){
            for (int j4 = 0; j4 < size; ++j4) {
                double d9 = adouble[j4 * 4 + 3];
                if (d9 < 0.0) continue;
                double d11 = adouble[j4 * 4 + 0];
                double d13 = adouble[j4 * 4 + 1];
                double d15 = adouble[j4 * 4 + 2];
                int k4 = Math.max(Mth.m_14107_((double)(d11 - d9)), pX);
                int l = Math.max(Mth.m_14107_((double)(d13 - d9)), pY);
                int i1 = Math.max(Mth.m_14107_((double)(d15 - d9)), pZ);
                int j1 = Math.max(Mth.m_14107_((double)(d11 + d9)), k4);
                int k1 = Math.max(Mth.m_14107_((double)(d13 + d9)), l);
                int l1 = Math.max(Mth.m_14107_((double)(d15 + d9)), i1);
                for (int absoluteX = k4; absoluteX <= j1; ++absoluteX) {
                    double d5 = ((double)absoluteX + 0.5 - d11) / d9;
                    if (!(d5 * d5 < 1.0)) continue;
                    for (int absoluteY = l; absoluteY <= k1; ++absoluteY) {
                        double d6 = ((double)absoluteY + 0.5 - d13) / d9;
                        if (!(d5 * d5 + d6 * d6 < 1.0)) continue;
                        for (int absoluteZ = i1; absoluteZ <= l1; ++absoluteZ) {
                            int l2;
                            double d7 = ((double)absoluteZ + 0.5 - d15) / d9;
                            if (!(d5 * d5 + d6 * d6 + d7 * d7 < 1.0) || level.m_151562_(absoluteY) || bitset.get(l2 = absoluteX - pX + (absoluteY - pY) * pWidth + (absoluteZ - pZ) * pWidth * pHeight)) continue;
                            bitset.set(l2);
                            mutableBlockPos.m_122178_(absoluteX, absoluteY, absoluteZ);
                            if (!level.m_180807_((BlockPos)mutableBlockPos) || !this.placeBlock(level, random, configuration, mutableBlockPos, bulksectionaccess, absoluteX, absoluteY, absoluteZ)) continue;
                            ++placedBlocks;
                        }
                    }
                }
            }
        }
        return placedBlocks > 0;
    }

    private boolean placeBlock(WorldGenLevel level, RandomSource random, MineralDepositConfiguration configuration, BlockPos.MutableBlockPos mutableBlockPos, BulkSectionAccess bulksectionaccess, int absoluteX, int absoluteY, int absoluteZ) {
        LevelChunkSection levelchunksection = bulksectionaccess.m_156104_((BlockPos)mutableBlockPos);
        if (levelchunksection == null) {
            return false;
        }
        int relativeX = SectionPos.m_123207_((int)absoluteX);
        int relativeY = SectionPos.m_123207_((int)absoluteY);
        int relativeZ = SectionPos.m_123207_((int)absoluteZ);
        BlockState oldBlockstate = levelchunksection.m_62982_(relativeX, relativeY, relativeZ);
        boolean mainBlockPlaced = false;
        for (MineralDepositConfiguration.DepositBlockStateInfo mainStateInfo : configuration.mainStateInfos) {
            if (!mainStateInfo.ruleTest.m_213865_(oldBlockstate, random)) continue;
            BlockState newBlockState = mainStateInfo.blockStateProvider.m_213972_(random, (BlockPos)mutableBlockPos);
            levelchunksection.m_62991_(relativeX, relativeY, relativeZ, newBlockState, false);
            mainBlockPlaced = true;
        }
        if (!mainBlockPlaced) {
            return false;
        }
        List<Direction> clusterDirections = this.getValidSidesForCluster(random, configuration, levelchunksection, relativeX, relativeY, relativeZ);
        try {
            for (int i = 0; i < clusterDirections.size(); ++i) {
                Direction randomDirection = clusterDirections.get(random.m_188503_(clusterDirections.size()));
                clusterDirections.remove(randomDirection);
                if (random.m_188501_() >= configuration.getClusterChance()) continue;
                int cX = relativeX + randomDirection.m_122429_();
                int cY = relativeY + randomDirection.m_122430_();
                int cZ = relativeZ + randomDirection.m_122431_();
                BlockState state = configuration.clusterStateInfo.blockStateProvider.m_213972_(random, (BlockPos)mutableBlockPos);
                if (state.m_61138_((Property)BlockStateProperties.f_61372_)) {
                    state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)randomDirection);
                }
                levelchunksection.m_62991_(cX, cY, cZ, state, false);
            }
        }
        catch (Exception e) {
            LogUtils.getLogger().error(e.toString());
        }
        return true;
    }

    protected List<Direction> getValidSidesForCluster(RandomSource random, MineralDepositConfiguration configuration, LevelChunkSection levelchunksection, int relativeX, int relativeY, int relativeZ) {
        ArrayList<Direction> airDirections = new ArrayList<Direction>();
        for (Direction dir : Direction.values()) {
            BlockState blockStateAtPos;
            int cX = relativeX + dir.m_122429_();
            int cY = relativeY + dir.m_122430_();
            int cZ = relativeZ + dir.m_122431_();
            if (cX < 0 || cX > 15 || cY < 0 || cY > 15 || cZ < 0 || cZ > 15 || !configuration.clusterStateInfo.ruleTest.m_213865_(blockStateAtPos = levelchunksection.m_62982_(cX, cY, cZ), random)) continue;
            airDirections.add(dir);
        }
        return airDirections;
    }
}

