/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.salt;

import io.github.mortuusars.salt.Salt;
import io.github.mortuusars.salt.configuration.Configuration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class Melting {
    public static final DispenseItemBehavior SALT_DISPENSER_BEHAVIOR = new SaltItemDispenseBehavior();

    public static boolean tryMeltFromItem(BlockState targetState, BlockPos targetPos, Level level) {
        if (((Boolean)Configuration.MELTING_ITEM_ENABLED.get()).booleanValue() && targetState.m_204336_(Salt.BlockTags.MELTABLES)) {
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                Melting.meltBlock(targetPos, serverLevel);
            } else {
                Vec3 center = Vec3.m_82512_((Vec3i)targetPos);
                RandomSource random = level.m_213780_();
                for (int i = 0; i < 6; ++i) {
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123764_, center.f_82479_ + random.m_188583_() * (double)0.35f, center.f_82480_ + (double)0.35f + random.m_188583_() * (double)0.35f, center.f_82481_ + random.m_188583_() * (double)0.35f, 0.0, 0.0, 0.0);
                }
            }
            return true;
        }
        return false;
    }

    public static boolean tryMeltFromBlock(BlockPos pos, ServerLevel level) {
        if (((Boolean)Configuration.MELTING_BY_BLOCK_ENABLED.get()).booleanValue() && level.m_8055_(pos).m_204336_(Salt.BlockTags.MELTABLES) && level.f_46441_.m_188500_() < (Double)Configuration.MELTING_BLOCK_CHANCE.get()) {
            Melting.meltBlock(pos, level);
            return true;
        }
        return false;
    }

    public static void meltBlock(BlockPos pos, ServerLevel level) {
        BlockState oldState = level.m_8055_(pos);
        BlockState newState = Blocks.f_50016_.m_49966_();
        if (((Boolean)Configuration.MELTING_PLACES_WATER.get()).booleanValue() && level.m_6042_().f_63857_()) {
            newState = Blocks.f_49990_.m_49966_();
        }
        level.m_46597_(pos, newState);
        Vec3 center = Vec3.m_82512_((Vec3i)pos);
        RandomSource random = level.m_213780_();
        level.m_6263_(null, center.f_82479_, center.f_82480_, center.f_82481_, (SoundEvent)Salt.Sounds.MELT.get(), SoundSource.BLOCKS, 0.9f, random.m_188501_() * 0.2f + 0.9f);
        level.m_6263_(null, center.f_82479_, center.f_82480_, center.f_82481_, (SoundEvent)Salt.Sounds.SALT_DISSOLVE.get(), SoundSource.BLOCKS, 0.9f, random.m_188501_() * 0.2f + 0.9f);
        BlockParticleOption particleType = new BlockParticleOption(ParticleTypes.f_123794_, oldState);
        for (int i = 0; i < 12; ++i) {
            level.m_8767_((ParticleOptions)particleType, center.f_82479_ + random.m_188583_() * (double)0.45f, center.f_82480_ + random.m_188583_() * (double)0.45f, center.f_82481_ + random.m_188583_() * (double)0.45f, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private static class SaltItemDispenseBehavior
    extends DefaultDispenseItemBehavior {
        private SaltItemDispenseBehavior() {
        }

        protected ItemStack m_7498_(BlockSource source, ItemStack stack) {
            if (!stack.m_204117_(Salt.ItemTags.FORGE_SALTS)) {
                return stack;
            }
            Direction direction = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
            ItemStack itemstack = stack.m_41620_(1);
            BlockPos targetPos = source.m_7961_().m_121945_(direction);
            BlockState targetState = source.m_7727_().m_8055_(targetPos);
            if (!Melting.tryMeltFromItem(targetState, targetPos, (Level)source.m_7727_())) {
                Position position = DispenserBlock.m_52720_((BlockSource)source);
                SaltItemDispenseBehavior.m_123378_((Level)source.m_7727_(), (ItemStack)itemstack, (int)6, (Direction)direction, (Position)position);
            }
            return stack;
        }
    }
}

