/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.salt.block;

import io.github.mortuusars.salt.Salt;
import io.github.mortuusars.salt.helper.Heater;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CauldronBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class SaltCauldronBlock
extends LayeredCauldronBlock {
    private final Predicate<Biome.Precipitation> fillPredicate;

    public SaltCauldronBlock(Predicate<Biome.Precipitation> fillPredicate, Map<Item, CauldronInteraction> interactions) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50256_), fillPredicate, interactions);
        this.fillPredicate = fillPredicate;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)Items.f_42544_);
    }

    public void m_6786_(@NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockState state) {
        super.m_6786_(level, pos, state);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.dropContents(serverLevel, state, pos);
        }
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult blockHitResult) {
        if (player.m_21120_(hand).m_41619_()) {
            if (level instanceof ServerLevel) {
                ServerPlayer serverPlayer;
                ServerLevel serverLevel = (ServerLevel)level;
                this.dropContents(serverLevel, state, pos);
                serverLevel.m_46597_(pos, Blocks.f_50256_.m_49966_());
                serverLevel.m_5594_(null, pos, (SoundEvent)Salt.Sounds.SALT_CAULDRON_REMOVE_SALT.get(), SoundSource.BLOCKS, 0.8f, serverLevel.m_213780_().m_188501_() * 0.2f + 0.9f);
                if (player instanceof ServerPlayer && !(serverPlayer = (ServerPlayer)player).m_7500_()) {
                    Salt.Advancements.SALT_EVAPORATED.trigger(serverPlayer);
                }
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return super.m_6227_(state, level, pos, player, hand, blockHitResult);
    }

    protected void dropContents(ServerLevel level, BlockState state, BlockPos pos) {
        ResourceLocation lootTablePath = Salt.resource("cauldron_evaporation/salt_" + this.getFullnessString(state));
        LootTable lootTable = level.m_7654_().m_129898_().m_79217_(lootTablePath);
        LootContext.Builder lootContextBuilder = new LootContext.Builder(level).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pos));
        ObjectArrayList randomItems = lootTable.m_230922_(lootContextBuilder.m_78975_(LootContextParamSets.f_81410_));
        for (ItemStack itemStack : randomItems) {
            float x = (float)pos.m_123341_() + 0.4f + level.f_46441_.m_188501_() * 0.2f;
            float y = (float)pos.m_123342_() + 0.7f + level.f_46441_.m_188501_() * 0.2f;
            float z = (float)pos.m_123343_() + 0.4f + level.f_46441_.m_188501_() * 0.2f;
            ItemEntity itementity = new ItemEntity((Level)level, (double)x, (double)y, (double)z, itemStack);
            itementity.m_32010_(5);
            level.m_7967_((Entity)itementity);
        }
    }

    protected String getFullnessString(BlockState state) {
        return switch ((Integer)state.m_61143_((Property)f_153514_)) {
            case 1 -> "level_1";
            case 2 -> "level_2";
            default -> "full";
        };
    }

    public void m_7892_(@NotNull BlockState state, Level level, BlockPos pos, @NotNull Entity entity) {
        if (Heater.isHeatSource(level.m_8055_(pos.m_7495_())) && !entity.m_5825_() && entity instanceof LivingEntity && !EnchantmentHelper.m_44938_((LivingEntity)((LivingEntity)entity))) {
            entity.m_6469_(DamageSource.f_19305_, 1.0f);
        }
    }

    public void m_141997_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Biome.Precipitation precipitation) {
        if (CauldronBlock.m_182450_((Level)level, (Biome.Precipitation)precipitation) && Heater.isHeatSource(level.m_8055_(pos.m_7495_())) && this.fillPredicate.test(precipitation)) {
            if (precipitation == Biome.Precipitation.RAIN) {
                level.m_46597_(pos, Blocks.f_152476_.m_49966_());
                level.m_142346_(null, GameEvent.f_157769_, pos);
            } else if (precipitation == Biome.Precipitation.SNOW) {
                level.m_46597_(pos, Blocks.f_152478_.m_49966_());
                level.m_142346_(null, GameEvent.f_157769_, pos);
            }
        }
    }

    protected boolean m_142087_(@NotNull Fluid fluid) {
        return true;
    }

    protected void m_142310_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Fluid fluid) {
        if (fluid == Fluids.f_76195_) {
            level.m_46597_(pos, Blocks.f_152477_.m_49966_());
            level.m_46796_(1046, pos, 0);
            level.m_142346_(null, GameEvent.f_157769_, pos);
        } else if (Heater.isHeatSource(level.m_8055_(pos.m_7495_()))) {
            level.m_5594_(null, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, level.m_213780_().m_188501_() * 0.2f + 0.9f);
        } else if (fluid == Fluids.f_76193_) {
            level.m_46597_(pos, Blocks.f_152476_.m_49966_());
            level.m_46796_(1047, pos, 0);
            level.m_142346_(null, GameEvent.f_157769_, pos);
        }
    }
}

