/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.salt.client.rendering;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LayeredBakedModel
implements BakedModel {
    private List<BakedModel> layers;

    public LayeredBakedModel(List<BakedModel> layers) {
        this.layers = layers;
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData data, @Nullable RenderType renderType) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        for (BakedModel layer : this.layers) {
            List layerQuads = layer.getQuads(state, side, rand, data, renderType);
            quads.addAll(layerQuads);
        }
        return quads;
    }

    public List<BakedQuad> m_213637_(@Nullable BlockState pState, @Nullable Direction pDirection, RandomSource pRandom) {
        return this.getQuads(pState, pDirection, pRandom, ModelData.EMPTY, null);
    }

    public boolean m_7541_() {
        return this.layers.get(0).m_7541_();
    }

    public boolean m_7539_() {
        return this.layers.get(0).m_7539_();
    }

    public boolean m_7547_() {
        return this.layers.get(0).m_7547_();
    }

    public boolean m_7521_() {
        return this.layers.get(0).m_7521_();
    }

    public TextureAtlasSprite m_6160_() {
        return this.layers.get(0).m_6160_();
    }

    public ItemOverrides m_7343_() {
        return this.layers.get(0).m_7343_();
    }

    public ItemTransforms m_7442_() {
        return this.layers.get(0).m_7442_();
    }

    public static class Cache {
        private static final Int2ObjectMap<BakedModel> cache = new Int2ObjectOpenHashMap(256);

        public static void add(int key, BakedModel model) {
            cache.put(key, (Object)model);
        }

        @Nullable
        public static BakedModel get(int key) {
            return (BakedModel)cache.get(key);
        }

        public static void clear() {
            cache.clear();
        }
    }
}

