/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.salt.data.provider;

import com.google.gson.JsonElement;
import io.github.mortuusars.salt.Salt;
import java.io.IOException;
import java.nio.file.Path;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.ApplyExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LootTables
extends LootTableProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private final DataGenerator generator;

    public LootTables(DataGenerator generator) {
        super(generator);
        this.generator = generator;
    }

    public void m_213708_(CachedOutput cache) {
        this.writeTable(cache, Salt.Blocks.SALT_CAULDRON.getId(), LootTable.m_79147_().m_79165_(LootContextParamSets.f_81421_).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42544_)).m_79080_(ExplosionCondition.m_81661_())).m_79167_());
        this.dropsSelf(cache, (BlockItem)Salt.Items.SALT_BLOCK.get());
        this.dropsSelf(cache, (BlockItem)Salt.Items.RAW_ROCK_SALT_BLOCK.get());
        this.writeTable(cache, new ResourceLocation("salt:blocks/" + Salt.Blocks.ROCK_SALT_ORE.getId().m_135815_()), this.silkTouchOrDefaultTable((Block)Salt.Blocks.ROCK_SALT_ORE.get(), (Item)Salt.Items.RAW_ROCK_SALT.get(), 1.0f, 3.0f).m_79167_());
        this.writeTable(cache, new ResourceLocation("salt:blocks/" + Salt.Blocks.DEEPSLATE_ROCK_SALT_ORE.getId().m_135815_()), this.silkTouchOrDefaultTable((Block)Salt.Blocks.DEEPSLATE_ROCK_SALT_ORE.get(), (Item)Salt.Items.RAW_ROCK_SALT.get(), 1.0f, 3.0f).m_79167_());
        this.writeTable(cache, new ResourceLocation("salt:blocks/" + Salt.Blocks.SALT_CLUSTER.getId().m_135815_()), this.silkTouchOrDefaultTable((Block)Salt.Blocks.SALT_CLUSTER.get(), (Item)Salt.Items.RAW_ROCK_SALT.get(), 1.0f, 3.0f).m_79167_());
        this.writeTable(cache, new ResourceLocation("salt:blocks/" + Salt.Blocks.LARGE_SALT_BUD.getId().m_135815_()), this.silkTouchTable((Item)Salt.Items.LARGE_SALT_BUD.get()).m_79167_());
        this.writeTable(cache, new ResourceLocation("salt:blocks/" + Salt.Blocks.MEDIUM_SALT_BUD.getId().m_135815_()), this.silkTouchTable((Item)Salt.Items.MEDIUM_SALT_BUD.get()).m_79167_());
        this.writeTable(cache, new ResourceLocation("salt:blocks/" + Salt.Blocks.SMALL_SALT_BUD.getId().m_135815_()), this.silkTouchTable((Item)Salt.Items.SMALL_SALT_BUD.get()).m_79167_());
        this.dropsSelf(cache, (BlockItem)Salt.Items.SALT_LAMP.get());
        this.writeTable(cache, Salt.resource("cauldron_evaporation/salt_level_1"), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)Salt.Items.SALT.get())).m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.75f)))).m_79167_());
        this.writeTable(cache, Salt.resource("cauldron_evaporation/salt_level_2"), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)Salt.Items.SALT.get())).m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.9f)))).m_79167_());
        this.writeTable(cache, Salt.resource("cauldron_evaporation/salt_full"), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)Salt.Items.SALT.get())))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)Salt.Items.SALT.get())).m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.25f)))).m_79167_());
    }

    private void dropsSelf(CachedOutput cache, BlockItem blockItem) {
        this.writeTable(cache, new ResourceLocation("salt:blocks/" + ForgeRegistries.BLOCKS.getKey((Object)blockItem.m_40614_()).m_135815_()), LootTable.m_79147_().m_79165_(LootContextParamSets.f_81421_).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)blockItem))).m_79167_());
    }

    protected LootTable.Builder silkTouchTable(Item lootItem) {
        return LootTable.m_79147_().m_79165_(LootContextParamSets.f_81421_).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)lootItem).m_79080_(MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1)))))));
    }

    protected LootTable.Builder silkTouchOrDefaultTable(Block block, Item lootItem, float min, float max) {
        LootPool.Builder builder = LootPool.m_79043_().name(ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_()).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)AlternativesEntry.m_79395_((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[]{LootItem.m_79579_((ItemLike)block).m_79080_(MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1))))), LootItem.m_79579_((ItemLike)lootItem).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79915_((Enchantment)Enchantments.f_44987_)).m_79078_((LootItemFunction.Builder)ApplyExplosionDecay.m_80037_())}));
        return LootTable.m_79147_().m_79165_(LootContextParamSets.f_81421_).m_79161_(builder);
    }

    private void writeTable(CachedOutput cache, ResourceLocation location, LootTable lootTable) {
        Path outputFolder = this.generator.m_123916_();
        Path path = outputFolder.resolve("data/" + location.m_135827_() + "/loot_tables/" + location.m_135815_() + ".json");
        try {
            DataProvider.m_236072_((CachedOutput)cache, (JsonElement)net.minecraft.world.level.storage.loot.LootTables.m_79200_((LootTable)lootTable), (Path)path);
        }
        catch (IOException e) {
            LOGGER.error("Couldn't write loot lootTable {}", (Object)path, (Object)e);
        }
    }
}

