/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.salt.integration.jei;

import com.google.common.collect.ImmutableList;
import io.github.mortuusars.salt.Salt;
import io.github.mortuusars.salt.configuration.Configuration;
import io.github.mortuusars.salt.crafting.recipe.SaltingRecipe;
import io.github.mortuusars.salt.integration.jei.category.SaltCrystalGrowingCategory;
import io.github.mortuusars.salt.integration.jei.category.SaltEvaporationCategory;
import io.github.mortuusars.salt.integration.jei.resource.SaltCrystalGrowingDummy;
import io.github.mortuusars.salt.integration.jei.resource.SaltEvaporationDummy;
import io.github.mortuusars.salt.integration.jei.resource.SaltingShapelessExtension;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IVanillaCategoryExtensionRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class SaltJeiPlugin
implements IModPlugin {
    public static final RecipeType<SaltEvaporationDummy> SALT_EVAPORATION_RECIPE_TYPE = RecipeType.create((String)"salt", (String)"salt_evaporation", SaltEvaporationDummy.class);
    public static final RecipeType<SaltCrystalGrowingDummy> SALT_CRYSTAL_GROWING_RECIPE_TYPE = RecipeType.create((String)"salt", (String)"salt_crystal_growing", SaltCrystalGrowingDummy.class);
    private static final ResourceLocation ID = Salt.resource("jei_plugin");

    @NotNull
    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerCategories(@NotNull IRecipeCategoryRegistration registration) {
        if (this.isSaltEvaporationEnabled()) {
            registration.addRecipeCategories(new IRecipeCategory[]{new SaltEvaporationCategory(registration.getJeiHelpers().getGuiHelper())});
        }
        if (this.isSaltCrystalGrowingEnabled()) {
            registration.addRecipeCategories(new IRecipeCategory[]{new SaltCrystalGrowingCategory(registration.getJeiHelpers().getGuiHelper())});
        }
    }

    public void registerRecipeCatalysts(@NotNull IRecipeCatalystRegistration registration) {
        if (this.isSaltEvaporationEnabled()) {
            registration.addRecipeCatalyst(new ItemStack((ItemLike)Items.f_42544_), new RecipeType[]{SALT_EVAPORATION_RECIPE_TYPE});
        }
        if (this.isSaltCrystalGrowingEnabled()) {
            registration.addRecipeCatalyst(new ItemStack((ItemLike)Salt.Items.RAW_ROCK_SALT_BLOCK.get()), new RecipeType[]{SALT_CRYSTAL_GROWING_RECIPE_TYPE});
        }
    }

    public void registerRecipes(@NotNull IRecipeRegistration registration) {
        if (this.isSaltEvaporationEnabled()) {
            registration.addRecipes(SALT_EVAPORATION_RECIPE_TYPE, (List)ImmutableList.of((Object)new SaltEvaporationDummy()));
        }
        if (this.isSaltCrystalGrowingEnabled()) {
            registration.addRecipes(SALT_CRYSTAL_GROWING_RECIPE_TYPE, (List)ImmutableList.of((Object)new SaltCrystalGrowingDummy()));
        }
    }

    public void registerVanillaCategoryExtensions(IVanillaCategoryExtensionRegistration registration) {
        registration.getCraftingCategory().addCategoryExtension(SaltingRecipe.class, SaltingShapelessExtension::new);
    }

    private boolean isSaltEvaporationEnabled() {
        return (Boolean)Configuration.JEI_SALT_EVAPORATION_ENABLED.get() != false && (Boolean)Configuration.EVAPORATION_ENABLED.get() != false && (Double)Configuration.EVAPORATION_CHANCE.get() > 0.0 && !Objects.requireNonNull(ForgeRegistries.BLOCKS.tags()).getTag(Salt.BlockTags.HEATERS).isEmpty();
    }

    private boolean isSaltCrystalGrowingEnabled() {
        return (Boolean)Configuration.JEI_SALT_CRYSTAL_GROWING_ENABLED.get() != false && (Boolean)Configuration.SALT_CLUSTER_GROWING_ENABLED.get() != false && (Double)Configuration.SALT_CLUSTER_GROWING_CHANCE.get() > 0.0;
    }
}

