/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.salt.mixin;

import io.github.mortuusars.salt.Salt;
import io.github.mortuusars.salt.configuration.Configuration;
import io.github.mortuusars.salt.helper.Heater;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractCauldronBlock.class})
public abstract class WaterCauldronMixin
extends Block {
    public WaterCauldronMixin(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")}, cancellable=true)
    private void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random, CallbackInfo ci) {
        if (((Boolean)Configuration.EVAPORATION_ENABLED.get()).booleanValue() && state.m_60713_(Blocks.f_50256_) && Heater.isHeatSource(level.m_8055_(pos.m_7495_()))) {
            BlockPos stalactitePos = PointedDripstoneBlock.m_154055_((Level)level, (BlockPos)pos);
            if (stalactitePos == null) {
                return;
            }
            Fluid fluid = PointedDripstoneBlock.m_221849_((ServerLevel)level, (BlockPos)stalactitePos);
            if (fluid != Fluids.f_76195_) {
                Vec3 center = Vec3.m_82512_((Vec3i)pos);
                level.m_6263_(null, center.f_82479_, center.f_82480_, center.f_82481_, (SoundEvent)Salt.Sounds.CAULDRON_EVAPORATE.get(), SoundSource.BLOCKS, 0.6f, level.m_213780_().m_188501_() * 0.2f + 1.0f);
                level.m_7106_((ParticleOptions)ParticleTypes.f_123796_, center.f_82479_, center.f_82480_ + (double)0.2f, center.f_82481_, 0.0, (double)0.02f, 0.0);
                ci.cancel();
            }
        }
    }
}

