/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.servercountryflags.common.config;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.FileSystems;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Arrays;
import java.util.Properties;
import me.khajiitos.servercountryflags.common.ServerCountryFlags;
import me.khajiitos.servercountryflags.common.config.ConfigEntry;
import me.khajiitos.servercountryflags.common.config.Constraints;
import me.khajiitos.servercountryflags.common.util.Color;
import me.khajiitos.servercountryflags.common.util.FlagPosition;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.resources.language.LanguageManager;

public class Config {
    private static File configDirectory;
    private static File propertiesFile;
    private static WatchService watchService;
    public static final Values DEFAULT;
    public static final Values cfg;

    public static void init() {
        String minecraftDir = Minecraft.m_91087_().f_91069_.getAbsolutePath();
        configDirectory = new File(minecraftDir + "/config/servercountryflags");
        propertiesFile = new File(configDirectory.getAbsolutePath() + "/servercountryflags.properties");
        Config.load();
        Config.registerWatchService();
    }

    public static void load() {
        Properties properties = new Properties();
        boolean loadedProperties = false;
        try {
            properties.load(new FileReader(propertiesFile));
            loadedProperties = true;
        }
        catch (FileNotFoundException e) {
            ServerCountryFlags.LOGGER.info("Our properties file doesn't exist, creating it");
            try {
                boolean ignored = configDirectory.mkdirs();
                if (!propertiesFile.createNewFile()) {
                    ServerCountryFlags.LOGGER.warn("Our properties file actually exists... What?");
                }
                Config.save();
            }
            catch (IOException ex) {
                ServerCountryFlags.LOGGER.error("Couldn't create the properties file");
                ServerCountryFlags.LOGGER.error(ex.getMessage());
            }
        }
        catch (IOException e) {
            ServerCountryFlags.LOGGER.error("Couldn't read the properties file");
            ServerCountryFlags.LOGGER.error(e.getMessage());
        }
        if (!loadedProperties) {
            return;
        }
        boolean rewriteConfig = false;
        block8: for (Field field : Values.class.getDeclaredFields()) {
            ConfigEntry annotation = field.getAnnotation(ConfigEntry.class);
            if (annotation == null) continue;
            String propertiesValue = properties.getProperty(field.getName());
            if (propertiesValue == null) {
                rewriteConfig = true;
                continue;
            }
            try {
                if (field.getType() == String.class) {
                    field.set(cfg, propertiesValue);
                    continue;
                }
                if (field.getType() == Boolean.TYPE) {
                    field.setBoolean(cfg, Boolean.parseBoolean(propertiesValue));
                    continue;
                }
                if (field.getType() == Integer.TYPE) {
                    ?[] constraints = Arrays.stream(annotation.constraints()).findFirst();
                    int value = Integer.parseInt(propertiesValue);
                    if (constraints.isPresent()) {
                        value = Math.max(Math.min(value, ((Constraints)constraints.get()).maxValue()), ((Constraints)constraints.get()).minValue());
                    }
                    field.setInt(cfg, value);
                    continue;
                }
                if (field.getType() == Float.TYPE) {
                    field.setFloat(cfg, Float.parseFloat(propertiesValue));
                    continue;
                }
                if (field.getType().isEnum()) {
                    for (Object enumConstant : field.getType().getEnumConstants()) {
                        if (!enumConstant.toString().equals(propertiesValue)) continue;
                        field.set(cfg, enumConstant);
                        continue block8;
                    }
                    continue;
                }
                if (field.getType() == Color.class) {
                    field.set(cfg, Color.fromString(propertiesValue));
                    continue;
                }
                ServerCountryFlags.LOGGER.warn("Bug: unsupported config type " + field.getType().getSimpleName());
            }
            catch (IllegalAccessException e) {
                ServerCountryFlags.LOGGER.warn("Bug: can't modify a config field");
            }
            catch (NumberFormatException e) {
                ServerCountryFlags.LOGGER.warn("Field " + field.getName() + " in the properties type is not of type " + field.getType().getSimpleName());
            }
        }
        if (rewriteConfig) {
            ServerCountryFlags.LOGGER.info("Properties file doesn't contain all fields available, rewriting it");
            Config.save();
        }
        Config.afterLoad();
    }

    private static void afterLoad() {
        if (Config.cfg.forceEnglish) {
            ServerCountryFlags.updateAPILanguage(null);
        } else {
            LanguageManager languageManager = Minecraft.m_91087_().m_91102_();
            if (languageManager != null) {
                ServerCountryFlags.updateAPILanguage(languageManager.m_118983_().getCode());
            }
        }
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof JoinMultiplayerScreen) {
            screen.m_6574_(Minecraft.m_91087_(), screen.f_96543_, screen.f_96544_);
        }
    }

    public static void save() {
        Properties properties = new Properties();
        for (Field field : Values.class.getDeclaredFields()) {
            ConfigEntry annotation = field.getAnnotation(ConfigEntry.class);
            if (annotation == null) continue;
            try {
                properties.setProperty(field.getName(), String.valueOf(field.get(cfg)));
            }
            catch (IllegalAccessException e) {
                ServerCountryFlags.LOGGER.warn("Bug: can't access a config field");
            }
        }
        try {
            properties.store(new BufferedWriter(new FileWriter(propertiesFile)), "Server Country Flags properties file");
        }
        catch (FileNotFoundException e) {
            ServerCountryFlags.LOGGER.error("Couldn't save the properties file because it doesn't exist");
        }
        catch (IOException e) {
            ServerCountryFlags.LOGGER.error("Couldn't save the properties file");
            ServerCountryFlags.LOGGER.error(e.getMessage());
        }
    }

    private static void registerWatchService() {
        try {
            watchService = FileSystems.getDefault().newWatchService();
            Paths.get(propertiesFile.getParent(), new String[0]).register(watchService, StandardWatchEventKinds.ENTRY_MODIFY);
            Thread watcherThread = new Thread(() -> {
                try {
                    while (true) {
                        WatchKey key = watchService.take();
                        Thread.sleep(250L);
                        if (!key.pollEvents().isEmpty()) {
                            ServerCountryFlags.LOGGER.info("Properties file modified, reloading it");
                            Config.load();
                        }
                        key.reset();
                    }
                }
                catch (Exception e) {
                    ServerCountryFlags.LOGGER.warn("WatchService closed");
                    return;
                }
            });
            watcherThread.setName("File watcher");
            watcherThread.start();
        }
        catch (IOException e) {
            ServerCountryFlags.LOGGER.error("Couldn't initialize WatchService");
        }
    }

    static {
        DEFAULT = new Values();
        cfg = new Values();
    }

    public static class Values {
        @ConfigEntry(configCategory="servercountryflags.config.category.border")
        public boolean flagBorder = true;
        @ConfigEntry(configCategory="servercountryflags.config.category.border")
        public Color borderColor = new Color(65, 65, 65, 255);
        @ConfigEntry(configCategory="servercountryflags.config.category.border")
        public boolean reloadOnRefresh = false;
        @ConfigEntry(configCategory="servercountryflags.config.category.preferences")
        public boolean showDistance = true;
        @ConfigEntry(configCategory="servercountryflags.config.category.locale")
        public boolean useKm = true;
        @ConfigEntry(configCategory="servercountryflags.config.category.locale")
        public boolean forceEnglish = false;
        @ConfigEntry(configCategory="servercountryflags.config.category.preferences")
        public boolean displayUnknownFlag = true;
        @ConfigEntry(configCategory="servercountryflags.config.category.preferences")
        public boolean displayCooldownFlag = true;
        @ConfigEntry(configCategory="servercountryflags.config.category.preferences")
        public boolean showDistrict = false;
        @ConfigEntry(configCategory="servercountryflags.config.category.preferences")
        public boolean showISP = false;
        @ConfigEntry(configCategory="servercountryflags.config.category.preferences")
        public boolean mapButton = true;
        @ConfigEntry(configCategory="servercountryflags.config.category.preferences")
        public boolean mapButtonRight = true;
        @ConfigEntry(configCategory="servercountryflags.config.category.preferences")
        public boolean showHomeOnMap = true;
        @ConfigEntry(configCategory="servercountryflags.config.category.preferences")
        public boolean resolveRedirects = true;
        @ConfigEntry(configCategory="servercountryflags.config.category.preferences", stringValues={"left", "right", "behindName", "bottomRight"})
        public FlagPosition flagPosition = FlagPosition.BEHIND_NAME;
        @ConfigEntry(configCategory="servercountryflags.config.category.preferences", requiredMod="serverbrowser")
        public boolean serverBrowserIntegration = true;
    }
}

