/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.skinlayers.mixin;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.tr7zw.skinlayers.SkinLayersModBase;
import dev.tr7zw.skinlayers.SkinUtil;
import dev.tr7zw.skinlayers.SkullRendererCache;
import dev.tr7zw.skinlayers.util.NMSWrapper;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.Block;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BlockEntityWithoutLevelRenderer.class})
public class BlockEntityWithoutLevelRendererMixin {
    @Inject(method={"renderByItem"}, at={@At(value="HEAD")})
    public void renderByItem(ItemStack itemStack, ItemTransforms.TransformType transformType, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int j, CallbackInfo info) {
        GameProfile gameProfile;
        Block block;
        if (!SkinLayersModBase.config.enableSkullsItems) {
            return;
        }
        Item item = itemStack.m_41720_();
        if (item instanceof BlockItem && (block = ((BlockItem)item).m_40614_()) instanceof AbstractSkullBlock && (gameProfile = NMSWrapper.getGameProfile(itemStack)) != null) {
            SkullRendererCache.lastSkull = SkullRendererCache.itemCache.computeIfAbsent(itemStack, it -> new SkullRendererCache.ItemSettings());
            if (!SkullRendererCache.lastSkull.initialized() && SkullRendererCache.lastSkull.getHeadLayers() == null) {
                SkinUtil.setup3dLayers(gameProfile, SkullRendererCache.lastSkull);
            }
            SkullRendererCache.renderNext = SkullRendererCache.lastSkull.getHeadLayers() != null;
        }
    }
}

