/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.skinlayers.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import dev.tr7zw.skinlayers.api.Mesh;
import dev.tr7zw.skinlayers.api.MeshTransformer;
import dev.tr7zw.skinlayers.api.SkinLayersAPI;
import dev.tr7zw.skinlayers.versionless.render.CustomModelPart;
import dev.tr7zw.skinlayers.versionless.render.CustomizableCube;
import java.util.List;
import java.util.Map;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;

public class CustomizableModelPart
extends CustomModelPart
implements Mesh {
    private final List<ModelPart.Cube> cubes;
    private final Map<String, ModelPart> children;
    private Vector4f[] vector4f = new Vector4f[]{new Vector4f(), new Vector4f(), new Vector4f(), new Vector4f()};

    public CustomizableModelPart(List<ModelPart.Cube> list, List<CustomizableCube> customCubes, Map<String, ModelPart> map) {
        super(customCubes);
        this.cubes = list;
        this.children = map;
    }

    @Override
    public void loadPose(PartPose partPose) {
        this.x = partPose.f_171405_;
        this.y = partPose.f_171406_;
        this.z = partPose.f_171407_;
        this.xRot = partPose.f_171408_;
        this.yRot = partPose.f_171409_;
        this.zRot = partPose.f_171410_;
    }

    @Override
    public void copyFrom(ModelPart modelPart) {
        this.xRot = modelPart.f_104203_;
        this.yRot = modelPart.f_104204_;
        this.zRot = modelPart.f_104205_;
        this.x = modelPart.f_104200_;
        this.y = modelPart.f_104201_;
        this.z = modelPart.f_104202_;
    }

    @Override
    public void render(PoseStack poseStack, VertexConsumer vertexConsumer, int i, int j) {
        this.render(null, poseStack, vertexConsumer, i, j, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    private int convertFloatColorToInteger(float color) {
        return color > 1.0f ? 255 : Math.round(color * 255.0f);
    }

    @Deprecated(forRemoval=true)
    public void render(ModelPart vanillaModel, PoseStack poseStack, VertexConsumer vertexConsumer, int light, int overlay, float red, float green, float blue, float alpha) {
        int color = (this.convertFloatColorToInteger(alpha) & 0xFF) << 24 | (this.convertFloatColorToInteger(red) & 0xFF) << 16 | (this.convertFloatColorToInteger(green) & 0xFF) << 8 | this.convertFloatColorToInteger(blue) & 0xFF;
        this.render(vanillaModel, poseStack, vertexConsumer, light, overlay, color);
    }

    @Override
    public void render(ModelPart vanillaModel, PoseStack poseStack, VertexConsumer vertexConsumer, int light, int overlay, int color) {
        if (!this.visible) {
            return;
        }
        poseStack.m_85836_();
        this.translateAndRotate(poseStack);
        this.compile(vanillaModel, poseStack.m_85850_(), vertexConsumer, light, overlay, color);
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        for (ModelPart modelPart : this.children.values()) {
            modelPart.m_104306_(poseStack, vertexConsumer, light, overlay, r, g, b, a);
        }
        poseStack.m_85849_();
    }

    public void translateAndRotate(PoseStack poseStack) {
        poseStack.m_85837_((double)(this.x / 16.0f), (double)(this.y / 16.0f), (double)(this.z / 16.0f));
        if (this.zRot != 0.0f) {
            poseStack.m_85845_(Vector3f.f_122227_.m_122270_(this.zRot));
        }
        if (this.yRot != 0.0f) {
            poseStack.m_85845_(Vector3f.f_122225_.m_122270_(this.yRot));
        }
        if (this.xRot != 0.0f) {
            poseStack.m_85845_(Vector3f.f_122223_.m_122270_(this.xRot));
        }
    }

    private void compile(ModelPart vanillaModel, PoseStack.Pose pose, VertexConsumer vertexConsumer, int light, int overlay, int color) {
        MeshTransformer transformer = SkinLayersAPI.getMeshTransformerProvider().prepareTransformer(vanillaModel);
        Matrix4f matrix4f = pose.m_85861_();
        Matrix3f matrix3f = pose.m_85864_();
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        for (int id = 0; id < this.polygonData.length; id += 23) {
            int o;
            Vector3f vector3f = new Vector3f(this.polygonData[id + 0], this.polygonData[id + 1], this.polygonData[id + 2]);
            for (o = 0; o < 4; ++o) {
                this.vector4f[o].m_123602_(this.polygonData[id + 3 + o * 5 + 0], this.polygonData[id + 3 + o * 5 + 1], this.polygonData[id + 3 + o * 5 + 2], 1.0f);
            }
            transformer.transform(vector3f, this.vector4f);
            vector3f.m_122249_(matrix3f);
            for (o = 0; o < 4; ++o) {
                this.vector4f[o].m_123607_(matrix4f);
                vertexConsumer.m_5954_(this.vector4f[o].m_123601_(), this.vector4f[o].m_123615_(), this.vector4f[o].m_123616_(), red, green, blue, alpha, this.polygonData[id + 3 + o * 5 + 3], this.polygonData[id + 3 + o * 5 + 4], overlay, light, vector3f.m_122239_(), vector3f.m_122260_(), vector3f.m_122269_());
            }
        }
        for (ModelPart.Cube cube : this.cubes) {
            transformer.transform(cube);
            cube.m_171332_(pose, vertexConsumer, light, overlay, red, green, blue, alpha);
        }
    }
}

