/*
 * Decompiled with CFR 0.152.
 */
package com.possible_triangle.sliceanddice.block.slicer;

import com.jozufozu.flywheel.api.Instancer;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.core.materials.oriented.OrientedData;
import com.possible_triangle.sliceanddice.SlicerPartials;
import com.possible_triangle.sliceanddice.block.slicer.SlicerTile;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.flwdata.RotatingData;
import com.simibubi.create.content.kinetics.simpleRelays.encased.EncasedCogInstance;
import com.simibubi.create.foundation.render.AllMaterialSpecs;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u0010H\u0014J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u000eH\u0016J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0012H\u0002J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0012H\u0002J\b\u0010\u0017\u001a\u00020\u000eH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \n*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/possible_triangle/sliceanddice/block/slicer/SlicerInstance;", "Lcom/simibubi/create/content/kinetics/simpleRelays/encased/EncasedCogInstance;", "Lcom/jozufozu/flywheel/api/instance/DynamicInstance;", "modelManager", "Lcom/jozufozu/flywheel/api/MaterialManager;", "mixer", "Lcom/possible_triangle/sliceanddice/block/slicer/SlicerTile;", "(Lcom/jozufozu/flywheel/api/MaterialManager;Lcom/possible_triangle/sliceanddice/block/slicer/SlicerTile;)V", "mixerHead", "Lcom/simibubi/create/content/kinetics/base/flwdata/RotatingData;", "kotlin.jvm.PlatformType", "mixerPole", "Lcom/jozufozu/flywheel/core/materials/oriented/OrientedData;", "beginFrame", "", "getCogModel", "Lcom/jozufozu/flywheel/api/Instancer;", "getRenderedHeadOffset", "", "remove", "transformHead", "renderedHeadOffset", "transformPole", "updateLight", "sliceanddice-forge-2.3.3"})
public final class SlicerInstance
extends EncasedCogInstance
implements DynamicInstance {
    @NotNull
    private final SlicerTile mixer;
    private final OrientedData mixerPole;
    private final RotatingData mixerHead;

    public SlicerInstance(@NotNull MaterialManager modelManager, @NotNull SlicerTile mixer) {
        Intrinsics.checkNotNullParameter((Object)modelManager, (String)"modelManager");
        Intrinsics.checkNotNullParameter((Object)((Object)mixer), (String)"mixer");
        super(modelManager, (KineticBlockEntity)mixer, false);
        this.mixer = mixer;
        this.mixerPole = (OrientedData)this.getOrientedMaterial().getModel(AllPartialModels.MECHANICAL_MIXER_POLE, this.blockState).createInstance();
        this.mixerHead = ((RotatingData)this.getRotatingMaterial().getModel(SlicerPartials.INSTANCE.getSLICER_HEAD(), this.blockState).createInstance()).setRotationAxis(Direction.Axis.Y);
        float renderedHeadOffset = this.getRenderedHeadOffset();
        this.transformPole(renderedHeadOffset);
        this.transformHead(renderedHeadOffset);
    }

    @NotNull
    protected Instancer<RotatingData> getCogModel() {
        Instancer instancer = this.materialManager.defaultSolid().material(AllMaterialSpecs.ROTATING).getModel(AllPartialModels.SHAFTLESS_COGWHEEL, ((KineticBlockEntity)this.blockEntity).m_58900_());
        Intrinsics.checkNotNullExpressionValue((Object)instancer, (String)"getModel(...)");
        return instancer;
    }

    public void beginFrame() {
        float renderedHeadOffset = this.getRenderedHeadOffset();
        this.transformPole(renderedHeadOffset);
        this.transformHead(renderedHeadOffset);
    }

    private final void transformHead(float renderedHeadOffset) {
        float speed = this.mixer.getRenderedHeadRotationSpeed();
        this.mixerHead.setPosition(this.getInstancePosition()).nudge(0.0f, -renderedHeadOffset, 0.0f).setRotationalSpeed(speed * (float)2);
    }

    private final void transformPole(float renderedHeadOffset) {
        this.mixerPole.setPosition(this.getInstancePosition()).nudge(0.0f, -renderedHeadOffset, 0.0f);
    }

    private final float getRenderedHeadOffset() {
        return this.mixer.getRenderedHeadOffset(AnimationTickHolder.getPartialTicks());
    }

    public void updateLight() {
        super.updateLight();
        FlatLit[] flatLitArray = new FlatLit[]{this.mixerHead};
        this.relight(this.pos.m_7495_(), flatLitArray);
        flatLitArray = new FlatLit[]{this.mixerPole};
        this.relight(this.pos, flatLitArray);
    }

    public void remove() {
        super.remove();
        this.mixerHead.delete();
        this.mixerPole.delete();
    }
}

