/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.smarterfarmers.mixins;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.smarterfarmers.CountOrderedSortedMap;
import net.mehvahdjukaar.smarterfarmers.SFPlatformStuff;
import net.mehvahdjukaar.smarterfarmers.SmarterFarmers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.behavior.HarvestFarmland;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={HarvestFarmland.class})
public abstract class FarmTaskMixin {
    @Shadow
    private BlockPos f_23159_;
    @Shadow
    private long f_23160_;
    @Final
    @Shadow
    private List<BlockPos> f_23162_;
    @Shadow
    private int f_23161_;

    @Shadow
    protected abstract BlockPos m_23164_(ServerLevel var1);

    private boolean canHarvest(BlockState state) {
        CropBlock crop;
        Block b = state.m_60734_();
        if (state.m_60795_()) {
            return false;
        }
        return b instanceof CropBlock && (crop = (CropBlock)b).m_52307_(state) || b instanceof SweetBerryBushBlock && (Integer)state.m_61143_((Property)SweetBerryBushBlock.f_57244_) == 2 || FarmTaskMixin.hardcodedCheckMaxAge(state, b);
    }

    private static boolean hardcodedCheckMaxAge(BlockState state, Block b) {
        return SFPlatformStuff.isPlantable(state) && (FarmTaskMixin.checkAge(state, BlockStateProperties.f_61405_, 1) || FarmTaskMixin.checkAge(state, BlockStateProperties.f_61406_, 2) || FarmTaskMixin.checkAge(state, BlockStateProperties.f_61407_, 3) || FarmTaskMixin.checkAge(state, BlockStateProperties.f_222999_, 4) || FarmTaskMixin.checkAge(state, BlockStateProperties.f_61408_, 5) || FarmTaskMixin.checkAge(state, BlockStateProperties.f_61409_, 7));
    }

    private static boolean checkAge(BlockState state, IntegerProperty property, int max) {
        return state.m_61138_((Property)property) && (Integer)state.m_61143_((Property)property) == max;
    }

    private boolean canSpecialBreak(BlockState state) {
        return state.m_204336_(SmarterFarmers.SPECIAL_HARVESTABLE) || this.canBreakNoReplant(state);
    }

    private boolean canBreakNoReplant(BlockState state) {
        return state.m_204336_(SmarterFarmers.NO_REPLANT);
    }

    private boolean canPlantOn(BlockState state) {
        return state.m_60734_() instanceof FarmBlock || state.m_204336_(SmarterFarmers.VALID_FARMLAND);
    }

    @Inject(method={"start(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/npc/Villager;J)V"}, at={@At(value="HEAD")})
    public void start(ServerLevel pLevel, Villager pEntity, long pGameTime, CallbackInfo ci) {
        if (pGameTime > this.f_23160_ && this.f_23159_ != null) {
            pEntity.m_8061_(EquipmentSlot.MAINHAND, this.getHoe(pEntity));
        }
    }

    @Inject(method={"stop(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/npc/Villager;J)V"}, at={@At(value="HEAD")})
    public void stop(ServerLevel pLevel, Villager pEntity, long pGameTime, CallbackInfo ci) {
        pEntity.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
    }

    protected ItemStack getHoe(Villager pEntity) {
        return switch (pEntity.m_7141_().m_35576_()) {
            default -> Items.f_42387_.m_7968_();
            case 1 -> Items.f_42424_.m_7968_();
            case 2 -> Items.f_42429_.m_7968_();
            case 4 -> Items.f_42434_.m_7968_();
            case 5 -> Items.f_42392_.m_7968_();
            case 6 -> Items.f_42397_.m_7968_();
        };
    }

    @Overwrite
    protected boolean m_23180_(BlockPos pPos, ServerLevel pLevel) {
        BlockState cropState = pLevel.m_8055_(pPos);
        BlockState farmState = pLevel.m_8055_(pPos.m_7495_());
        return (cropState.m_60795_() || this.canHarvest(cropState)) && this.canPlantOn(farmState) || this.canSpecialBreak(cropState) && (this.canPlantOn(farmState) || farmState.m_60713_(Blocks.f_50493_));
    }

    @Inject(method={"tick(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/npc/Villager;J)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void tick(ServerLevel level, Villager villager, long l, CallbackInfo ci) {
        if (this.f_23159_ == null || this.f_23159_.m_203195_((Position)villager.m_20182_(), 1.0)) {
            if (this.f_23159_ != null && l > this.f_23160_) {
                CropBlock cropBlock;
                BlockState toHarvest = level.m_8055_(this.f_23159_);
                Block block = toHarvest.m_60734_();
                BlockPos belowPos = this.f_23159_.m_7495_();
                Item toReplace = Items.f_41852_;
                if (this.canSpecialBreak(toHarvest)) {
                    level.m_46953_(this.f_23159_, true, (Entity)villager);
                    BlockState below = level.m_8055_(belowPos);
                    if (below.m_60713_(Blocks.f_50493_)) {
                        level.m_7731_(belowPos, Blocks.f_50093_.m_49966_(), 11);
                        level.m_5594_(null, belowPos, SoundEvents.f_11955_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                    if (this.canBreakNoReplant(toHarvest)) {
                        ++this.f_23161_;
                        ci.cancel();
                        return;
                    }
                } else if (this.canHarvest(toHarvest)) {
                    toReplace = block.m_5456_();
                    level.m_46953_(this.f_23159_, true, (Entity)villager);
                }
                BlockState farmlandBlock = level.m_8055_(belowPos);
                if (level.m_8055_(this.f_23159_).m_60795_() && this.canPlantOn(farmlandBlock)) {
                    SimpleContainer inventory = villager.m_35311_();
                    ItemStack itemStack = ItemStack.f_41583_;
                    boolean canPlant = false;
                    int ind = -1;
                    if (toReplace != Items.f_41852_ && toReplace instanceof BlockItem) {
                        for (int i = 0; i < inventory.m_6643_(); ++i) {
                            itemStack = inventory.m_8020_(i);
                            if (itemStack.m_41720_() != toReplace) continue;
                            canPlant = true;
                            ind = i;
                            break;
                        }
                    }
                    if (!canPlant) {
                        Optional opt;
                        CountOrderedSortedMap<Block> map = new CountOrderedSortedMap<Block>();
                        map.add(level.m_8055_(this.f_23159_.m_122012_()).m_60734_());
                        map.add(level.m_8055_(this.f_23159_.m_122019_()).m_60734_());
                        map.add(level.m_8055_(this.f_23159_.m_122029_()).m_60734_());
                        map.add(level.m_8055_(this.f_23159_.m_122024_()).m_60734_());
                        ArrayList surroundingBlocks = new ArrayList();
                        map.entrySet().stream().sorted(Map.Entry.comparingByValue()).forEach(e -> surroundingBlocks.add((Block)e.getKey()));
                        HashMap<Block, Integer> availableSeeds = new HashMap<Block, Integer>();
                        for (int i = 0; i < inventory.m_6643_(); ++i) {
                            itemStack = inventory.m_8020_(i);
                            Item it = itemStack.m_41720_();
                            Block cc = SFPlatformStuff.getCropFromSeed(level, this.f_23159_, it);
                            if (cc == null) continue;
                            availableSeeds.put(cc, i);
                        }
                        for (Block b : surroundingBlocks) {
                            if (!availableSeeds.containsKey(b)) continue;
                            ind = (Integer)availableSeeds.get(b);
                            canPlant = true;
                            itemStack = inventory.m_8020_(ind);
                            break;
                        }
                        if (!canPlant && (opt = availableSeeds.values().stream().findFirst()).isPresent()) {
                            ind = (Integer)opt.get();
                            canPlant = true;
                            itemStack = inventory.m_8020_(ind);
                        }
                    }
                    if (canPlant) {
                        level.m_7731_(this.f_23159_, SFPlatformStuff.getPlant(level, this.f_23159_, itemStack), 3);
                        level.m_6263_(null, (double)this.f_23159_.m_123341_(), (double)this.f_23159_.m_123342_(), (double)this.f_23159_.m_123343_(), SoundEvents.f_11839_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        itemStack.m_41774_(1);
                        if (itemStack.m_41619_()) {
                            inventory.m_6836_(ind, ItemStack.f_41583_);
                        }
                    }
                }
                if (block instanceof CropBlock && !(cropBlock = (CropBlock)block).m_52307_(toHarvest)) {
                    this.f_23162_.remove(this.f_23159_);
                    this.f_23159_ = this.m_23164_(level);
                    if (this.f_23159_ != null) {
                        this.f_23160_ = l + 20L;
                        villager.m_6274_().m_21879_(MemoryModuleType.f_26370_, (Object)new WalkTarget((PositionTracker)new BlockPosTracker(this.f_23159_), 0.5f, 1));
                        villager.m_6274_().m_21879_(MemoryModuleType.f_26371_, (Object)new BlockPosTracker(this.f_23159_));
                    }
                }
            }
            ++this.f_23161_;
        }
        ci.cancel();
    }
}

